<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db     = DB::get();
$admin  = $_SESSION['admin_user'];

// ===================== ANA İSTATİSTİKLER =====================

// Toplam kullanıcı
$totalUsers = (int)$db->query("SELECT COUNT(*) FROM portal_users")->fetchColumn();

// Toplam ticket
try {
    $totalTickets = (int)$db->query("SELECT COUNT(*) FROM portal_tickets")->fetchColumn();
} catch (Exception $e) { $totalTickets = 0; }

// Açık ticket sayısı
try {
    $openTickets = (int)$db->query("SELECT COUNT(*) FROM portal_tickets WHERE status = 'open'")->fetchColumn();
} catch (Exception $e) { $openTickets = 0; }

// Evren sayısı
try {
    $universeCount = (int)$db->query("SELECT COUNT(*) FROM portal_universes")->fetchColumn();
} catch (Exception $e) { $universeCount = 0; }

// Son 24 saatte yeni kullanıcı
try {
    $newUsers24 = (int)$db->query("
        SELECT COUNT(*) FROM portal_users 
        WHERE created_at >= (NOW() - INTERVAL 1 DAY)
    ")->fetchColumn();
} catch (Exception $e) { $newUsers24 = 0; }

// Bugün açılan ticket
try {
    $ticketsToday = (int)$db->query("
        SELECT COUNT(*) FROM portal_tickets 
        WHERE created_at >= CURDATE()
    ")->fetchColumn();
} catch (Exception $e) { $ticketsToday = 0; }

// Son 5 kayıt olan kullanıcı
$lastUsers = $db->query("
    SELECT id, username, email 
    FROM portal_users 
    ORDER BY id DESC 
    LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);

// ===================== SON 10 ADMIN LOGU =====================
try {
    $logs = $db->query("
        SELECT id, admin_id, type, message, created_at 
        FROM portal_logs 
        ORDER BY id DESC 
        LIMIT 10
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $logs = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Kontrol Paneli</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Kontrol Paneli</h1>
        <span>Genel yönetim görünümü</span>
    </div>

    <div class="at-user">
        <div class="at-user-info">
            <span class="at-user-label">Admin</span>
            <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
        </div>
        <div class="at-user-avatar"><span>A</span></div>
    </div>
</header>

<main class="admin-content">

    <!-- ÜST İSTATİSTİK KARTLARI -->
    <div class="admin-stats-grid">

        <div class="admin-stat-card asc-blue">
            <div class="asc-label">Toplam Kullanıcı</div>
            <div class="asc-value"><?= number_format($totalUsers); ?></div>
            <div class="asc-sub">Son 24 saatte <b><?= $newUsers24 ?></b> yeni kayıt</div>
        </div>

        <div class="admin-stat-card asc-green">
            <div class="asc-label">Toplam Ticket</div>
            <div class="asc-value"><?= number_format($totalTickets); ?></div>
            <div class="asc-sub">Bugün açılan ticket: <b><?= $ticketsToday ?></b></div>
        </div>

        <div class="admin-stat-card asc-yellow">
            <div class="asc-label">Açık Ticket</div>
            <div class="asc-value"><?= number_format($openTickets); ?></div>
            <div class="asc-sub">Cevap bekleyen destek talepleri</div>
        </div>

        <div class="admin-stat-card asc-purple">
            <div class="asc-label">Evren Sayısı</div>
            <div class="asc-value"><?= number_format($universeCount); ?></div>
            <div class="asc-sub">Toplam evren</div>
        </div>

    </div>

    <!-- ALT GRID (SOL: Kullanıcılar) (SAĞ: Admin Logları) -->
    <div class="admin-lower-grid">

        <!-- SOL PANEL -->
        <div class="admin-panel-card">
            <div class="apc-header">
                <h2>Son Kayıt Olan Kullanıcılar</h2>
                <div class="apc-sub">En son 5 kullanıcı</div>
            </div>

            <table class="apc-table">
                <thead>
                    <tr><th>ID</th><th>Kullanıcı</th><th>Email</th></tr>
                </thead>
                <tbody>
                <?php foreach ($lastUsers as $u): ?>
                    <tr>
                        <td><?= $u['id'] ?></td>
                        <td><?= htmlspecialchars($u['username']) ?></td>
                        <td><?= htmlspecialchars($u['email']) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>


        <!-- SAĞ PANEL – ADMIN LOGS -->
        <div class="admin-panel-card">
            <div class="apc-header">
                <h2>Son Yönetici İşlemleri</h2>
                <div class="apc-sub">Panel üzerinde gerçekleşen son 10 işlem</div>
            </div>

            <?php if (empty($logs)): ?>
                <p>Herhangi bir log kaydı bulunamadı.</p>
            <?php else: ?>
                <table class="apc-table">
                    <thead>
                        <tr>
                            <th>Tür</th>
                            <th>Mesaj</th>
                            <th>Tarih</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?= htmlspecialchars($log['type']); ?></td>
                            <td><?= htmlspecialchars($log['message']); ?></td>
                            <td><?= htmlspecialchars($log['created_at']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>

    </div>

</main>

</div>

</body>
</html>
