<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db = DB::get();

$id = intval($_POST['id'] ?? 0);
if (!$id) die("ID yok");

// Talebi çek
$stmt = $db->prepare("SELECT * FROM portal_profile_changes WHERE id = ?");
$stmt->execute([$id]);
$req = $stmt->fetch();

if (!$req) die("Kayıt bulunamadı");

$userId = intval($req['user_id']);
$field  = $req['field'];

// Admin id çek
$adminId = $_SESSION['admin_user']['id'];

/* ============================================================
   ONAY
============================================================ */
if (isset($_POST['approve'])) {

    // Kullanıcı tablosunu güncelle
    if ($field === 'username') {
        $up = $db->prepare("UPDATE portal_users SET username = ? WHERE id = ?");
        $up->execute([$req['new_value'], $userId]);
    }

    if ($field === 'email') {
        $up = $db->prepare("UPDATE portal_users SET email = ? WHERE id = ?");
        $up->execute([$req['new_value'], $userId]);
    }

    if ($field === 'avatar') {
        $up = $db->prepare("UPDATE portal_users SET avatar = ? WHERE id = ?");
        $up->execute([$req['new_value'], $userId]);
    }

    // Talebi güncelle
    $stmt = $db->prepare("
        UPDATE portal_profile_changes
        SET status='approved', admin_id=?, decided_at=NOW()
        WHERE id=?
    ");
    $stmt->execute([$adminId, $id]);

    header("Location: profile_changes.php?ok=1");
    exit;
}

/* ============================================================
   REDDETME
============================================================ */
if (isset($_POST['reject'])) {

    $note = trim($_POST['note'] ?? '');
    if ($note === '') $note = "Sebep belirtilmedi.";

    $stmt = $db->prepare("
        UPDATE portal_profile_changes
        SET status='rejected', admin_note=?, admin_id=?, decided_at=NOW()
        WHERE id=?
    ");
    $stmt->execute([$note, $adminId, $id]);

    header("Location: profile_changes.php?rejected=1");
    exit;
}

die("Geçersiz istek.");
