<?php
// admin/users.php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';
require_once __DIR__ . '/includes/Logger.php';

$db     = DB::get();
$admin  = $_SESSION['admin_user'] ?? null;

// Küçük helper: güvenli COUNT
function safeCount($db, $sql, $params = [])
{
    try {
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        return (int)$stmt->fetchColumn();
    } catch (Exception $e) {
        return 0;
    }
}

/* ============= PORTAL İSTATİSTİKLERİ ============= */

$totalUsers = safeCount($db, "SELECT COUNT(*) FROM portal_users");

$newUsers24h = safeCount(
    $db,
    "SELECT COUNT(*) FROM portal_users WHERE DATE(created_at) = CURDATE()"
);

$usersWithAvatar = safeCount(
    $db,
    "SELECT COUNT(*) FROM portal_users WHERE avatar IS NOT NULL AND avatar != ''"
);

$totalAdmins = safeCount($db, "SELECT COUNT(*) FROM portal_admins");


/* ============= EVREN KULLANICI İSTATİSTİKLERİ (DİNAMİK) ============= */

$universeStats = [];

try {
    $unis = $db->query("SELECT id, name, db_name FROM portal_universes ORDER BY id ASC")->fetchAll();

    foreach ($unis as $uni) {

        // Gerçek tablo: novapus_steem.uni1_users
        $table = $uni['db_name'] . ".uni1_users";

        $count = 0;
        try {
            $count = safeCount($db, "SELECT COUNT(*) FROM {$table}");
        } catch (Exception $e) {
            $count = 0;
        }

        $universeStats[] = [
            'name'  => $uni['name'],
            'count' => $count
        ];
    }

} catch (Exception $e) {
    $universeStats = [];
}




/* ============= LİSTE & ARAMA ============= */

$search  = trim($_GET['s'] ?? "");

$page    = max(1, intval($_GET['p'] ?? 1));
$perPage = 20;
$offset  = ($page - 1) * $perPage;

$where  = "";
$params = [];

if ($search !== "") {
    $where  = "WHERE username LIKE ? OR email LIKE ?";
    $params = ["%$search%", "%$search%"];

    Logger::write(
        "admin_action",
        "Admin kullanıcı araması yaptı: '{$search}'",
        $admin['id'] ?? 0
    );
}

$totalQuery = $db->prepare("SELECT COUNT(*) FROM portal_users $where");
$totalQuery->execute($params);
$totalUsersFiltered = (int)$totalQuery->fetchColumn();

$usersQuery = $db->prepare("
    SELECT id, username, email, avatar, created_at
    FROM portal_users 
    $where
    ORDER BY id DESC
    LIMIT $offset, $perPage
");
$usersQuery->execute($params);
$users = $usersQuery->fetchAll();

$totalPages = max(1, ceil($totalUsersFiltered / $perPage));
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Kullanıcılar</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . "/includes/sidebar.php"; ?>

<div class="admin-main">

    <header class="admin-topbar">
        <div class="at-title">
            <h1>Kullanıcı Yönetimi</h1>
            <span>Portal kullanıcılarını görüntüle ve yönet</span>
        </div>

        <div class="at-user">
            <div class="at-user-info">
                <span class="at-user-label">Admin</span>
                <span class="at-user-name"><?= htmlspecialchars($admin['username'] ?? 'admin'); ?></span>
            </div>
            <div class="at-user-avatar"><span>A</span></div>
        </div>
    </header>

    <main class="admin-content">


        <!-- ===== ÜST MİNİ İSTATİSTİKLER ===== -->
        <div class="admin-stats-grid" style="margin-bottom:18px;">

            <div class="admin-stat-card asc-blue">
                <div class="asc-label">Toplam Kullanıcı</div>
                <div class="asc-value"><?= $totalUsers; ?></div>
                <div class="asc-sub">Portala kayıtlı tüm kullanıcılar</div>
            </div>

            <div class="admin-stat-card asc-green">
                <div class="asc-label">Son 24 Saatte Kayıt Olan</div>
                <div class="asc-value"><?= $newUsers24h; ?></div>
                <div class="asc-sub">Güncel kayıt aktivitesi</div>
            </div>

            <div class="admin-stat-card asc-yellow">
                <div class="asc-label">Avatarı Olan Kullanıcı</div>
                <div class="asc-value"><?= $usersWithAvatar; ?></div>
                <div class="asc-sub">Profil fotoğrafı yüklemiş hesaplar</div>
            </div>

            <div class="admin-stat-card asc-purple">
                <div class="asc-label">Admin Sayısı</div>
                <div class="asc-value"><?= $totalAdmins; ?></div>
                <div class="asc-sub">portal_admins tablosundaki yöneticiler</div>
            </div>

            <?php foreach ($universeStats as $u): ?>
                <div class="admin-stat-card asc-blue">
                    <div class="asc-label"><?= htmlspecialchars($u['name']); ?> Kullanıcı</div>
                    <div class="asc-value"><?= (int)$u['count']; ?></div>
                    <div class="asc-sub"><?= htmlspecialchars($u['name']); ?> evrenine kayıtlı oyuncular</div>
                </div>
            <?php endforeach; ?>

        </div>

        <!-- ARAMA BAR -->
        <form method="get" class="admin-search-bar">
            <input type="text" name="s" placeholder="Kullanıcı adı veya e-posta ara..."
                   value="<?= htmlspecialchars($search) ?>">
            <button class="admin-btn-search">Ara</button>
        </form>

        <!-- Kullanıcı kartları -->
        <div class="admin-user-list">

            <?php if (empty($users)): ?>
                <div class="admin-panel-card">
                    Arama kriterine uygun kullanıcı bulunamadı.
                </div>
            <?php endif; ?>

            <?php foreach ($users as $u): ?>

                <?php
$avatarRaw = trim($u['avatar']);

// Eğer avatar alanı boşsa → default avatar
if ($avatarRaw == "" || $avatarRaw == null) {
    $avatar = "/portal/assets/img/default-avatar.png";

// Eğer avatar alanı tam URL ise → direkt kullan
} elseif (str_starts_with($avatarRaw, "http")) {
    $avatar = $avatarRaw;

// Eğer avatar "assets/img/" ile başlıyorsa → default avatar yolu
} elseif (str_starts_with($avatarRaw, "assets/img/")) {
    $avatar = "/portal/" . $avatarRaw;

// Eğer avatar "uploads/avatars/" ile başlıyorsa → doğru upload klasörü
} elseif (str_contains($avatarRaw, "uploads/avatars/")) {
    $avatar = "/portal/" . $avatarRaw;

// Eğer sadece dosya adıysa → uploads klasörüne yönlendir
} else {
    $avatar = "/portal/assets/uploads/avatars/" . $avatarRaw;
}
?>


                <div class="admin-user-card">

                    <div class="auc-avatar">
                        <img src="<?= $avatar ?>" alt="">
                    </div>

                    <div class="auc-info">
                        <div class="auc-name">
                            <?= htmlspecialchars($u['username']) ?>
                            <span style="font-size:11px;color:#9ca3af;margin-left:4px;">
                                #<?= (int)$u['id']; ?>
                            </span>
                        </div>
                        <div class="auc-email"><?= htmlspecialchars($u['email']) ?></div>

                        <div class="auc-id">
                            Kayıt: <?= htmlspecialchars($u['created_at']); ?>
                        </div>
                    </div>

                    <div class="auc-actions">
                        <a href="user_edit.php?id=<?= (int)$u['id'] ?>" class="btn-admin-small blue">Yönet</a>
                    </div>

                </div>

            <?php endforeach; ?>

        </div>

        <!-- SAYFALAMA -->
        <div class="admin-pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <a class="ap-item <?= ($i == $page) ? 'active' : '' ?>"
                   href="?p=<?= $i ?>&s=<?= urlencode($search) ?>">
                    <?= $i ?>
                </a>
            <?php endfor; ?>
        </div>

    </main>

</div>

</body>
</html>
