<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mailer.php';

if (!isset($_SESSION['portal_user'])) {
    header("Location: index.php?page=login");
    exit;
}

$db   = DB::get();
$user = $_SESSION['portal_user'];

$token = bin2hex(random_bytes(32));

$stmt = $db->prepare("
    UPDATE portal_users
    SET email_verify_token = ?
    WHERE id = ?
");
$stmt->execute([$token, $user['id']]);

$verifyLink = "https://novapus.com/portal/verify_email.php?token=" . $token;

// Mail gönder
sendVerificationMail($user['email'], $user['username'], $verifyLink);

// PROFİLE GERİ YÖNLENDİR — HEM verify_pending HEM resent BİRLİKTE!
header("Location: index.php?page=profile&verify_pending=1&resent=1");
exit;
