<?php

class ShowMarketAdminPage extends AbstractAdminPage
{
    public static $requireModule = 0;

    function __construct()
    {
        parent::__construct();
    }

    // =====================================================
    //  ANA SAYFA (Paket listesi + Sipariş listesi)
    // =====================================================
    public function show()
    {
        global $LNG;

        $db = Database::get();

        // Paketler
        $packages = $db->select("SELECT * FROM %%MARKET_PACKAGES%% ORDER BY id DESC");

        // Siparişler
        $orders = $db->select("SELECT O.*, U.username, P.title 
                               FROM %%MARKET_ORDERS%% O
                               LEFT JOIN %%USERS%% U ON U.id = O.userID
                               LEFT JOIN %%MARKET_PACKAGES%% P ON P.id = O.packageID
                               ORDER BY O.id DESC");

        $this->assign([
            'packages' => $packages,
            'orders'   => $orders,
        ]);

        $this->display('market_admin.tpl');
    }

    // =====================================================
    //  PAKET AKTİF / PASİF
    // =====================================================
    public function activate()
    {
        $id = HTTP::_GP('id', 0);

        Database::get()->update(
            "UPDATE %%MARKET_PACKAGES%% 
             SET active = IF(active=1,0,1) 
             WHERE id = :id",
            [':id' => $id]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }

    // =====================================================
    //  PAKET SİL
    // =====================================================
    public function delete()
    {
        $id = HTTP::_GP('id', 0);

        Database::get()->delete(
            "DELETE FROM %%MARKET_PACKAGES%% WHERE id = :id",
            [':id' => $id]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }

    // =====================================================
    //  YENİ PAKET FORMU
    // =====================================================
    public function add()
    {
        $this->display('market_admin_add.tpl');
    }

    // =====================================================
    //  YENİ PAKET KAYDET
    // =====================================================
    public function addSave()
    {
        $type         = HTTP::_GP('type', '');
        $title        = HTTP::_GP('title', '');
        $description  = HTTP::_GP('description', '');
        $price        = HTTP::_GP('price', '');
        $rewardType   = HTTP::_GP('reward_type', '');
        $rewardValue  = HTTP::_GP('reward_value', 0);
        $image        = HTTP::_GP('image', '');

        Database::get()->insert(
            "INSERT INTO %%MARKET_PACKAGES%%
            SET type        = :type,
                title       = :title,
                description = :description,
                price       = :price,
                reward_type = :rewardType,
                reward_value= :rewardValue,
                image       = :image,
                active      = 1",
            [
                ':type'        => $type,
                ':title'       => $title,
                ':description' => $description,
                ':price'       => $price,
                ':rewardType'  => $rewardType,
                ':rewardValue' => $rewardValue,
                ':image'       => $image
            ]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }

    // =====================================================
    //  DÜZENLEME FORMU
    // =====================================================
    public function edit()
    {
        $id = HTTP::_GP('id', 0);

        $package = Database::get()->selectSingle(
            "SELECT * FROM %%MARKET_PACKAGES%% WHERE id = :id",
            [':id' => $id]
        );

        $this->assign([
            'package' => $package
        ]);

        $this->display('market_admin_edit.tpl');
    }

    // =====================================================
    //  PAKET DÜZENLEME KAYDET
    // =====================================================
    public function editSave()
    {
        $id           = HTTP::_GP('id', 0);
        $type         = HTTP::_GP('type', '');
        $title        = HTTP::_GP('title', '');
        $description  = HTTP::_GP('description', '');
        $price        = HTTP::_GP('price', '');
        $rewardType   = HTTP::_GP('reward_type', '');
        $rewardValue  = HTTP::_GP('reward_value', 0);
        $image        = HTTP::_GP('image', '');

        Database::get()->update(
            "UPDATE %%MARKET_PACKAGES%%
            SET type        = :type,
                title       = :title,
                description = :description,
                price       = :price,
                reward_type = :rewardType,
                reward_value= :rewardValue,
                image       = :image
            WHERE id = :id",
            [
                ':type'        => $type,
                ':title'       => $title,
                ':description' => $description,
                ':price'       => $price,
                ':rewardType'  => $rewardType,
                ':rewardValue' => $rewardValue,
                ':image'       => $image,
                ':id'          => $id
            ]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }

    // =====================================================
    //  ÖDEME ONAYLA
    // =====================================================
    public function approve()
    {
        $id = HTTP::_GP('id', 0);

        // Siparişi çek
        $order = Database::get()->selectSingle(
            "SELECT * FROM %%MARKET_ORDERS%% WHERE id = :id",
            [':id' => $id]
        );

        if (!$order) {
            $this->redirectTo("admin.php?page=marketAdmin");
        }

        // Paket bilgisi
        $package = Database::get()->selectSingle(
            "SELECT * FROM %%MARKET_PACKAGES%% WHERE id = :id",
            [':id' => $order['packageID']]
        );

        // Kullanıcı bilgisi
        $user = Database::get()->selectSingle(
            "SELECT * FROM %%USERS%% WHERE id = :id",
            [':id' => $order['userID']]
        );

        // ÖDÜL VER
        if ($package['reward_type'] == 'dm') {
            $user['darkmatter'] += $package['reward_value'];
        }
        elseif ($package['reward_type'] == 'metal') {
            $user['metal'] += $package['reward_value'];
        }
        elseif ($package['reward_type'] == 'crystal') {
            $user['crystal'] += $package['reward_value'];
        }
        elseif ($package['reward_type'] == 'deut') {
            $user['deuterium'] += $package['reward_value'];
        }

        // Kullanıcı güncelle
        Database::get()->update(
            "UPDATE %%USERS%% SET
                darkmatter = :dm,
                metal      = :metal,
                crystal    = :crystal,
                deuterium  = :deut
            WHERE id = :id",
            [
                ':dm'     => $user['darkmatter'],
                ':metal'  => $user['metal'],
                ':crystal'=> $user['crystal'],
                ':deut'   => $user['deuterium'],
                ':id'     => $user['id']
            ]
        );

        // Siparişi tamamlandı yap
        Database::get()->update(
            "UPDATE %%MARKET_ORDERS%% SET status = 'approved' WHERE id = :id",
            [':id' => $id]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }

    // =====================================================
    //  ÖDEME REDDET
    // =====================================================
    public function reject()
    {
        $id = HTTP::_GP('id', 0);

        Database::get()->update(
            "UPDATE %%MARKET_ORDERS%% 
             SET status = 'rejected' 
             WHERE id = :id",
            [':id' => $id]
        );

        $this->redirectTo("admin.php?page=marketAdmin");
    }
}

