{block name="title" prepend}{$LNG.lm_overview}{/block}
{block name="content"}

<style>
/* ===================================================
   NOVAPUS OVERVIEW – LOCAL CSS (SAFE)
   =================================================== */

.novapus-overview {
    position: relative;
    height: 340px;
    border-radius: 10px;
    overflow: hidden;
    margin-bottom: 15px;
    background: radial-gradient(circle at top, #0b1d2e, #020814);
}

/* Gezegen türüne göre arka plan */
.novapus-overview.overview-ice {
    background-image: url(styles/theme/gow/img/overview/ice.webp);
}

.novapus-overview.overview-desert {
    background-image: url(styles/theme/gow/img/overview/desert.webp);
}

.novapus-overview.overview-gas {
    background-image: url(styles/theme/gow/img/overview/gas.webp);
}

.novapus-overview.overview-ocean {
    background-image: url(styles/theme/gow/img/overview/ocean.webp);
}

.novapus-overview.overview-forest {
    background-image: url(styles/theme/gow/img/overview/forest.webp);
}

.novapus-overview.overview-moon {
    background-image: url(styles/theme/gow/img/overview/moon.webp);
}


/* Sol üst başlık */
.overview-header {
    position: absolute;
    top: 16px;
    left: 20px;
    z-index: 3;
}
.planet-title {
    font-size: 20px;
    font-weight: 700;
    color: #e6f1ff;
}
.planet-meta {
    font-size: 12px;
    color: #7aa7d9;
}

/* Gezegen sol alt */
.overview-planet-visual {
    position: absolute;
    bottom: -10px;
    left: -5px;
    z-index: 1;
}
.planet-main {
    width: 180px;
    filter: drop-shadow(0 0 45px rgba(0,180,255,.45));
}

/* Ay */
.planet-moon {
    position: absolute;
    top: -10px;
    right: -10px;
    width: 70px;
    height: 70px;
    border-radius: 50%;
    z-index: 4;
}
.planet-moon img {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    filter: drop-shadow(0 0 18px rgba(200,200,255,.6));
}

/* Cam panel */
.glass-panel {
    background: rgba(10,20,35,.65);
    backdrop-filter: blur(6px);
    border: 1px solid rgba(120,180,255,.25);
    border-radius: 10px;
}

/* Sağ alt bilgi */
.overview-info {
    position: absolute;
    right: 5px;
    bottom: 15px;
    width: 360px;
    padding: 10px 16px;
    z-index: 3;
}

.info-title {
    font-size: 10px;
    font-weight: 700;
    color: #9fd6ff;
    margin-bottom: 8px;
    border-bottom: 1px solid rgba(120,180,255,.25);
    padding-bottom: 4px;
    text-align: center;
}

.info-row {
    display: flex;
    justify-content: space-between;
    font-size: 12px;
    color: #d7ecff;
    padding: 4px 0;
}
.info-row strong {
    color: #fff;
}
.info-row a {
    color: #7fd3ff;
    text-decoration: none;
}
.info-row a:hover {
    text-decoration: underline;
}

/* Aksiyonlar */
.info-actions {
    display: flex;
    gap: 6px;
    margin-top: 10px;
}
.info-actions .btn {
    flex: 1;
    font-size: 11px;
    padding: 4px 6px;
}
/* ===================================================
   AY SEÇİLİYKEN ÖZEL ARKA PLAN
   =================================================== */

.novapus-overview.moon-view {
    background: radial-gradient(circle at top, #1a1a1a, #050505);
    background-image: url(styles/theme/gow/img/planets/moon_bg.webp);
    background-size: cover;
    background-position: center;
}


/* Ay görünümünde ana gezegen daha küçük */
.novapus-overview.moon-view .planet-main {
    width: 180px;
    filter: drop-shadow(0 0 30px rgba(220,220,255,.35));
}

</style>

<script>
function showNews(){
    $.ajax({
        type: "POST",
        url: 'game.php?page=overview&mode=changeNewsVisibility&ajax=1',
        success: function () {
            $('#newsRow').toggleClass('d-none');
        }
    });
}
</script>

<!-- ================= MODERN OVERVIEW ================= -->
{assign var=imgKey value=$planetimage|lower}
{assign var=ovBg value='default.webp'}

{if strpos($imgKey, 'dschjungelplanet') !== false}
  {assign var=ovBg value='dschjungelplanet.webp'}
{elseif strpos($imgKey, 'eisplanet') !== false}
  {assign var=ovBg value='eisplanet.webp'}
{elseif strpos($imgKey, 'gasplanet') !== false}
  {assign var=ovBg value='gasplanet.webp'}
{elseif strpos($imgKey, 'normaltempplanet') !== false}
  {assign var=ovBg value='normaltempplanet.webp'}
{elseif strpos($imgKey, 'trockenplanet') !== false}
  {assign var=ovBg value='trockenplanet.webp'}
{elseif strpos($imgKey, 'wasserplanet') !== false}
  {assign var=ovBg value='wasserplanet.webp'}
{elseif strpos($imgKey, 'wuestenplanet') !== false}
  {assign var=ovBg value='wuestenplanet.webp'}
{elseif strpos($imgKey, 'mond') !== false}
  {assign var=ovBg value='mond.webp'}
{/if}


<div class="novapus-overview" style="background-image:url(styles/theme/gow/img/overview/{$ovBg}); background-size:cover; background-position:center;">




    <!-- Sol üst -->
    <div class="overview-header">
        <div class="planet-title">{$planetname}</div>
        <div class="planet-meta">
            [{$galaxy}:{$system}:{$planet}] • {$LNG["type_planet_{$planet_type}"]}
        </div>
    </div>

    <!-- Gezegen -->
    <div class="overview-planet-visual">
        <a href="?page=overview&cp={$planet_id}">
            <img class="planet-main"
                 src="{$dpath}planeten/{$planetimage}.jpg"
                 alt="{$planetname}">
        </a>

        {if $Moon}
        <a href="game.php?page=overview&amp;cp={$Moon.id}"
           class="planet-moon"
           title="{$Moon.name}">
            <img src="{$dpath}planeten/{$Moon.image}.jpg"
                 alt="{$Moon.name}">
        </a>
        {/if}
    </div>

    <!-- Sağ alt bilgi -->
    <div class="overview-info glass-panel">

        

        <div class="info-row">
            <span>🌍 Çap</span>
            <strong>{$planet_diameter} km</strong>
        </div>

        <div class="info-row">
            <span>🌡️ Sıcaklık</span>
            <strong>{$planet_temp_min}{$LNG.ov_temp_unit} – {$planet_temp_max}{$LNG.ov_temp_unit}</strong>
        </div>

        <div class="info-row">
            <span>📍 Koordinat</span>
            <strong>
                <a href="game.php?page=galaxy&amp;galaxy={$galaxy}&amp;system={$system}">
                    [{$galaxy}:{$system}:{$planet}]
                </a>
            </strong>
        </div>

        <div class="info-row">
            <span>🏆 Puan</span>
            <strong>{$rankInfo}</strong>
        </div>

        <div class="info-actions">
            {if isModuleAvailable($smarty.const.MODULE_RELOCATE)}
            <a class="btn btn-sm btn-outline-info" href="game.php?page=relocate">
                İskan
            </a>
            {/if}

            <a class="btn btn-sm btn-outline-warning"
               href="#"
               onclick="return Dialog.PlanetAction();">
                İsmini Değiştir
            </a>
        </div>

    </div>

</div>
<!-- ================= /MODERN OVERVIEW ================= -->

{* ================= HABERLER ================= *}
{if !empty($news)}
<div class="text-center my-2">
    <button class="btn btn-dark py-0 px-2 border border-secondary fs-12 text-yellow"
            onclick="showNews();">
        {$LNG.ov_news}
    </button>
</div>

<div id="newsRow" class="{if $show_news_active}d-none{/if}">
    <table class="table table-gow fs-12">
        <thead>
            <tr>
                <th class="color-blue text-center" colspan="3">{$LNG.ov_news}</th>
            </tr>
        </thead>
        <tbody>
            {foreach $news as $currentNews}
            <tr>
                <td class="text-center color-blue">{$currentNews.user}</td>
                <td class="text-center color-blue">{$currentNews.date}</td>
                <td class="text-center color-blue">{$currentNews.text}</td>
            </tr>
            {/foreach}
        </tbody>
    </table>
</div>
{/if}

{* ================= QUEUE ================= *}
<div class="nova-overview-queue">

    <!-- Binalar -->
    <div class="queue-box">
        <div class="queue-title">{$LNG.lm_buildings}</div>
        {if $buildInfo.buildings}
        <form class="queue-cancel" action="game.php?page=buildings" method="post">
            <input type="hidden" name="cmd" value="cancel">
            <button class="queue-cancel-btn" type="submit">✖</button>
        </form>
        <div class="queue-content">
            <img src="{$dpath}gebaeude/{$buildInfo.buildings.id}.gif">
            <div>
                <div class="queue-name">{$LNG.tech[$buildInfo.buildings.id]}</div>
                <div class="queue-time" data-time="{$buildInfo.buildings.timeleft}">
                    {$buildInfo.buildings.starttime}
                </div>
            </div>
        </div>
        {else}
        <div class="queue-empty">{$LNG.ov_free}</div>
        {/if}
    </div>

    <!-- Araştırma -->
    <div class="queue-box">
        <div class="queue-title">{$LNG.lm_research}</div>
        {if $buildInfo.tech}
        <form class="queue-cancel" action="game.php?page=research" method="post">
            <input type="hidden" name="cmd" value="cancel">
            <button class="queue-cancel-btn" type="submit">✖</button>
        </form>
        <div class="queue-content">
            <img src="{$dpath}gebaeude/{$buildInfo.tech.id}.gif">
            <div>
                <div class="queue-name">{$LNG.tech[$buildInfo.tech.id]}</div>
                <div class="queue-time" data-time="{$buildInfo.tech.timeleft}">
                    {$buildInfo.tech.starttime}
                </div>
            </div>
        </div>
        {else}
        <div class="queue-empty">{$LNG.ov_free}</div>
        {/if}
    </div>

    <!-- Tersane -->
    <div class="queue-box">
        <div class="queue-title">{$LNG.lm_shipshard}</div>
        {if $buildInfo.fleet}
        <form class="queue-cancel" action="game.php?page=shipyard&amp;mode=fleet" method="post">
            <input type="hidden" name="cmd" value="cancel">
            <button class="queue-cancel-btn" type="submit">✖</button>
        </form>
        <div class="queue-content">
            <img src="{$dpath}gebaeude/{$buildInfo.fleet.id}.gif">
            <div>
                <div class="queue-name">{$LNG.tech[$buildInfo.fleet.id]}</div>
                <div class="queue-time" data-time="{$buildInfo.fleet.timeleft}">
                    {$buildInfo.fleet.starttime}
                </div>
            </div>
        </div>
        {else}
        <div class="queue-empty">{$LNG.ov_free}</div>
        {/if}
    </div>

</div>

{/block}
