<?php

class Settings {
    public static function get($key, $default = null) {
        $db = DB::get();
        $stmt = $db->prepare("SELECT setting_value FROM portal_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $row = $stmt->fetch();
        return $row ? $row['setting_value'] : $default;
    }

    public static function set($key, $value) {
        $db = DB::get();
        $stmt = $db->prepare("
            INSERT INTO portal_settings (setting_key, setting_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
        ");
        $stmt->execute([$key, $value]);
    }

    public static function all() {
        $db = DB::get();
        return $db->query("SELECT * FROM portal_settings")->fetchAll(PDO::FETCH_ASSOC);
    }
}