<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db = DB::get();
$admin = $_SESSION['admin_user'];

$filter = $_GET['type'] ?? 'all';

$where = "1";
if ($filter !== 'all') {
    $where = "type = " . $db->quote($filter);
}

$logs = $db->query("
    SELECT * FROM portal_logs 
    WHERE $where 
    ORDER BY id DESC LIMIT 200
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Log Kayıtları</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Log Kayıtları</h1>
        <span>Admin ve kullanıcı aktiviteleri</span>
    </div>
</header>

<main class="admin-content">

    <!-- Filtre -->
    <div class="ticket-filter">
        <a href="?type=all" class="tf-item <?= $filter=='all'?'active':'' ?>">Tümü</a>
        <a href="?type=admin_login" class="tf-item <?= $filter=='admin_login'?'active':'' ?>">Admin Girişleri</a>
        <a href="?type=user_login" class="tf-item <?= $filter=='user_login'?'active':'' ?>">Kullanıcı Girişleri</a>
        <a href="?type=admin_action" class="tf-item <?= $filter=='admin_action'?'active':'' ?>">Admin İşlemleri</a>
    </div>

    <table class="log-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Zaman</th>
                <th>IP</th>
                <th>Tür</th>
                <th>Aksiyon</th>
                <th>Admin</th>
                <th>Kullanıcı</th>
            </tr>
        </thead>
        <tbody>

        <?php foreach ($logs as $l): ?>
            <tr>
                <td><?= $l['id']; ?></td>
                <td><?= $l['created_at']; ?></td>
                <td><?= $l['ip']; ?></td>
                <td><?= $l['type']; ?></td>
                <td><?= htmlspecialchars($l['action']); ?></td>
                <td><?= $l['admin_id'] ?: '-'; ?></td>
                <td><?= $l['user_id'] ?: '-'; ?></td>
            </tr>
        <?php endforeach; ?>

        </tbody>
    </table>

</main>
</div>

</body>
</html>