<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db = DB::get();
$admin = $_SESSION['admin_user'];

// Sıra değiştirme
if (isset($_GET['move'], $_GET['id'])) {
    $id   = (int)$_GET['id'];
    $move = $_GET['move'];

    $stmt = $db->prepare("SELECT id, sort FROM portal_cms WHERE id = ?");
    $stmt->execute([$id]);
    $current = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($current) {
        if ($move === 'up') {
            $stmt = $db->prepare("SELECT id, sort FROM portal_cms WHERE sort < ? ORDER BY sort DESC LIMIT 1");
            $stmt->execute([$current['sort']]);
        } else {
            $stmt = $db->prepare("SELECT id, sort FROM portal_cms WHERE sort > ? ORDER BY sort ASC LIMIT 1");
            $stmt->execute([$current['sort']]);
        }
        $other = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($other) {
            $stmt = $db->prepare("UPDATE portal_cms SET sort = ? WHERE id = ?");
            $stmt->execute([$other['sort'], $current['id']]);

            $stmt->execute([$current['sort'], $other['id']]);
        }
    }

    header("Location: portal_pages.php");
    exit;
}

// Bloklar
$blocks = $db->query("SELECT * FROM portal_cms ORDER BY sort ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Portal CMS</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Portal CMS</h1>
        <span>Ana sayfa içerik bloklarını yönetin</span>
    </div>

    <div class="at-user">
        <div class="at-user-info">
            <span class="at-user-label">Admin</span>
            <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
        </div>
        <div class="at-user-avatar"><span>A</span></div>
    </div>
</header>

<main class="admin-content">

<a href="portal_page_add.php" class="btn-primary" style="margin-bottom:15px; display:inline-block;">
    + Yeni Blok Ekle
</a>

<section class="admin-panel-card">
    <div class="apc-header">
        <h2>Mevcut Bloklar</h2>
        <span class="apc-sub">Portal üzerinde gösterilen tüm içerik blokları</span>
    </div>

    <table class="apc-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Başlık</th>
                <th>Slug</th>
                <th>Tip</th>
                <th>Sıra</th>
                <th>Durum</th>
                <th>İşlemler</th>
            </tr>
        </thead>

        <tbody>
        <?php foreach ($blocks as $b): ?>
            <tr>
                <td><?= $b['id'] ?></td>
                <td><?= htmlspecialchars($b['title']) ?></td>
                <td><code><?= htmlspecialchars($b['slug']) ?></code></td>
                <td><?= htmlspecialchars($b['type']) ?></td>
                <td><?= (int)$b['sort'] ?></td>
                <td><?= $b['visible'] ? 'Aktif' : 'Pasif' ?></td>
                <td>
                    <a href="portal_pages.php?move=up&id=<?= $b['id'] ?>" class="btn-sm">↑</a>
                    <a href="portal_pages.php?move=down&id=<?= $b['id'] ?>" class="btn-sm">↓</a>
                    <a href="portal_page_edit.php?id=<?= $b['id'] ?>" class="btn-sm">Düzenle</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

</section>

</main>

</div>

</body>
</html>
