<?php
// admin/rules_edit.php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db     = DB::get();
$admin  = $_SESSION['admin_user'] ?? null;

// Kaydetme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $content = $_POST['content'] ?? '';

    $stmt = $db->prepare("UPDATE portal_rules SET content = ? WHERE id = 1");
    $stmt->execute([$content]);

    $success = "Kurallar başarıyla güncellendi.";
}

// Mevcut içerik
$stmt = $db->prepare("SELECT content FROM portal_rules WHERE id = 1");
$stmt->execute();
$rule = $stmt->fetchColumn();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Kurallar</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . "/includes/sidebar.php"; ?>

<div class="admin-main">

    <!-- ÜST BAR -->
    <header class="admin-topbar">
        <div class="at-title">
            <h1>Kurallar</h1>
            <span>Oyunculara gösterilen resmi oyun kuralları</span>
        </div>

        <div class="at-user">
            <div class="at-user-info">
                <span class="at-user-label">Admin</span>
                <span class="at-user-name"><?= htmlspecialchars($admin['username'] ?? 'admin'); ?></span>
            </div>
            <div class="at-user-avatar"><span>A</span></div>
        </div>
    </header>

    <!-- İÇERİK -->
    <main class="admin-content">

        <section class="admin-panel-card">

            <div class="apc-header">
                <h2>Oyun Kuralları</h2>
                <span class="apc-sub">
                    Portal ana sayfasında ve oyun içinde gösterilir
                </span>
            </div>

            <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>

            <form method="post">

                <textarea
                    name="content"
                    id="editor"
                    class="form-control"
                    style="min-height:420px;"
                ><?= htmlspecialchars($rule) ?></textarea>

                <div style="margin-top:16px;text-align:right;">
                    <button class="btn btn-primary">
                        💾 Kaydet
                    </button>
                </div>

            </form>

        </section>

    </main>

</div>

<script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script>
<script>
    CKEDITOR.replace('editor', {
        height: 380
    });
</script>

</body>
</html>
