<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db    = DB::get();
$admin = $_SESSION['admin_user'];

$message = '';
$success = '';

$editId  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$editUni = null;

/* ==========================
   KAYDET (EKLE / GÜNCELLE)
========================== */

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_universe'])) {

    $id        = (int)($_POST['id'] ?? 0);
    $name      = trim($_POST['name'] ?? '');
    $slug      = trim($_POST['slug'] ?? '');
    $url       = trim($_POST['url'] ?? '');
    $db_name   = trim($_POST['db_name'] ?? '');
    $db_user   = trim($_POST['db_user'] ?? '');
    $db_pass   = trim($_POST['db_pass'] ?? '');
    $status    = trim($_POST['status'] ?? 'active');
    $speed_f   = (int)($_POST['speed_fleet'] ?? 1);
    $speed_e   = (int)($_POST['speed_economy'] ?? 1);
    $speed_r   = (int)($_POST['speed_research'] ?? 1);
    $df_fleet  = (int)($_POST['fleet_to_debris'] ?? 0);
    $df_def    = (int)($_POST['defense_to_debris'] ?? 0);
    $short_desc = trim($_POST['short_description'] ?? '');

    if ($name === '' || $slug === '' || $url === '' || $db_name === '') {
        $message = "İsim, slug, URL ve veritabanı adı zorunludur.";
    } else {

        if ($id > 0) {
            // GÜNCELLE
            $stmt = $db->prepare("
                UPDATE portal_universes
                SET name = ?, slug = ?, url = ?, db_name = ?, db_user = ?, db_pass = ?,
                    status = ?, speed_fleet = ?, speed_economy = ?, speed_research = ?,
                    fleet_to_debris = ?, defense_to_debris = ?, short_description = ?
                WHERE id = ?
            ");
            $stmt->execute([
                $name, $slug, $url, $db_name, $db_user, $db_pass,
                $status, $speed_f, $speed_e, $speed_r,
                $df_fleet, $df_def, $short_desc,
                $id
            ]);

            Logger::write('admin_action', "Evren güncellendi: {$name}", $admin['id']);
            $success = "Evren başarıyla güncellendi.";
            $editId  = $id;

        } else {
            // YENİ EVREN EKLE
            $stmt = $db->prepare("
                INSERT INTO portal_universes
                (name, slug, url, db_name, db_user, db_pass,
                 status, speed_fleet, speed_economy, speed_research,
                 fleet_to_debris, defense_to_debris, short_description)
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)
            ");
            $stmt->execute([
                $name, $slug, $url, $db_name, $db_user, $db_pass,
                $status, $speed_f, $speed_e, $speed_r,
                $df_fleet, $df_def, $short_desc
            ]);

            Logger::write('admin_action', "Yeni evren oluşturuldu: {$name}", $admin['id']);
            $success = "Yeni evren eklendi.";
        }
    }
}

/* ==========================
   EVREN SİLME
========================== */

if (isset($_POST['delete_universe'])) {

    $delId = (int)$_POST['id'];

    $stmt = $db->prepare("DELETE FROM portal_universes WHERE id = ?");
    $stmt->execute([$delId]);

    Logger::write('admin_action', "Evren silindi (ID: {$delId})", $admin['id']);

    $success = "Evren silindi.";

    if ($editId == $delId) {
        $editId = 0;
    }
}

/* ==========================
   LİSTE + DÜZENLENECEK EVREN
========================== */

$universes = $db->query("SELECT * FROM portal_universes ORDER BY id ASC")->fetchAll();

if ($editId > 0) {
    $stm2 = $db->prepare("SELECT * FROM portal_universes WHERE id = ?");
    $stm2->execute([$editId]);
    $editUni = $stm2->fetch();
}

// Varsayılan form
$form = [
    'id'                => $editUni['id'] ?? 0,
    'name'              => $editUni['name'] ?? '',
    'slug'              => $editUni['slug'] ?? '',
    'url'               => $editUni['url'] ?? '',
    'db_name'           => $editUni['db_name'] ?? '',
    'db_user'           => $editUni['db_user'] ?? '',
    'db_pass'           => $editUni['db_pass'] ?? '',
    'status'            => $editUni['status'] ?? 'active',
    'speed_fleet'       => $editUni['speed_fleet'] ?? 1,
    'speed_economy'     => $editUni['speed_economy'] ?? 1,
    'speed_research'    => $editUni['speed_research'] ?? 1,
    'fleet_to_debris'   => $editUni['fleet_to_debris'] ?? 0,
    'defense_to_debris' => $editUni['defense_to_debris'] ?? 0,
    'short_description' => $editUni['short_description'] ?? '',
];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Evren Yönetimi</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Evren Yönetimi</h1>
        <span>Portal üzerinden tüm evrenleri yapılandır</span>
    </div>
</header>

<main class="admin-content">

<?php if ($success): ?>
    <div class="admin-success-box"><?= $success ?></div>
<?php endif; ?>

<?php if ($message): ?>
    <div class="admin-error-box"><?= $message ?></div>
<?php endif; ?>


<div class="admin-universe-grid">

    <!-- SOL: LİSTE -->
    <div class="admin-panel-card">
        <h2>Kayıtlı Evrenler</h2>

        <table class="apc-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>İsim</th>
                    <th>Slug</th>
                    <th>Durum</th>
                    <th>Hızlar</th>
                    <th>DF</th>
                    <th>İşlem</th>
                </tr>
            </thead>
            <tbody>

            <?php foreach ($universes as $uni): ?>
                <tr>
                    <td>#<?= $uni['id']; ?></td>
                    <td><?= htmlspecialchars($uni['name']); ?></td>
                    <td><?= htmlspecialchars($uni['slug']); ?></td>

                    <td>
                        <?php
                        if ($uni['status'] === 'active')
                            echo '<span class="uac-status uac-status-active">AKTİF</span>';
                        elseif ($uni['status'] === 'soon')
                            echo '<span class="uac-status uac-status-soon">YAKINDA</span>';
                        else
                            echo '<span class="uac-status uac-status-closed">KAPALI</span>';
                        ?>
                    </td>

                    <td>
                        F<?= $uni['speed_fleet']; ?> · 
                        E<?= $uni['speed_economy']; ?> · 
                        R<?= $uni['speed_research']; ?>
                    </td>

                    <td>
                        <?= $uni['fleet_to_debris']; ?>% /
                        <?= $uni['defense_to_debris']; ?>%
                    </td>

                    <td>
                        <a href="universes.php?id=<?= $uni['id']; ?>" class="btn-admin-small blue">Düzenle</a>

                        <form action="" style="display:inline;" method="post"
                              onsubmit="return confirm('Bu evreni silmek istediğine emin misin?');">
                            <input type="hidden" name="id" value="<?= $uni['id']; ?>">
                            <button type="submit" name="delete_universe" class="btn-admin-small red">Sil</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>

            </tbody>
        </table>
    </div>



    <!-- SAĞ: FORM -->
    <div class="admin-panel-card">
        <h2><?= $form['id'] ? "Evreni Düzenle (#{$form['id']})" : "Yeni Evren Ekle"; ?></h2>

        <form method="post" class="uni-form">

            <input type="hidden" name="id" value="<?= $form['id']; ?>">

            <label>Evren Adı
                <input type="text" name="name" value="<?= htmlspecialchars($form['name']); ?>">
            </label>

            <label>Slug (uni1, uni2…)
                <input type="text" name="slug" value="<?= htmlspecialchars($form['slug']); ?>">
            </label>

            <label>Evren URL
                <input type="text" name="url" value="<?= htmlspecialchars($form['url']); ?>">
            </label>

            <label>DB Adı
                <input type="text" name="db_name" value="<?= htmlspecialchars($form['db_name']); ?>">
            </label>

            <label>DB Kullanıcı
                <input type="text" name="db_user" value="<?= htmlspecialchars($form['db_user']); ?>">
            </label>

            <label>DB Şifre
                <input type="password" name="db_pass" value="<?= htmlspecialchars($form['db_pass']); ?>">
            </label>

            <label>Durum
                <select name="status">
                    <option value="active"  <?= $form['status']=='active'?'selected':''; ?>>Aktif</option>
                    <option value="soon"    <?= $form['status']=='soon'?'selected':''; ?>>Yakında</option>
                    <option value="closed"  <?= $form['status']=='closed'?'selected':''; ?>>Kapalı</option>
                </select>
            </label>

            <div class="uni-speed-grid">
                <label>Filo Hızı
                    <input type="number" name="speed_fleet" value="<?= $form['speed_fleet']; ?>">
                </label>
                <label>Ekonomi Hızı
                    <input type="number" name="speed_economy" value="<?= $form['speed_economy']; ?>">
                </label>
                <label>Araştırma Hızı
                    <input type="number" name="speed_research" value="<?= $form['speed_research']; ?>">
                </label>
            </div>

            <div class="uni-speed-grid">
                <label>DF Filo (%)
                    <input type="number" name="fleet_to_debris" value="<?= $form['fleet_to_debris']; ?>">
                </label>
                <label>DF Savunma (%)
                    <input type="number" name="defense_to_debris" value="<?= $form['defense_to_debris']; ?>">
                </label>
            </div>

            <label>Kısa Açıklama
                <textarea name="short_description" rows="3"><?= htmlspecialchars($form['short_description']); ?></textarea>
            </label>

            <button type="submit" name="save_universe" class="admin-btn-save">
                <?= $form['id'] ? "Güncelle" : "Oluştur"; ?>
            </button>

        </form>
    </div>

</div>

</main>
</div>

</body>
</html>