<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once __DIR__ . '/../includes/db.php';

// SADE YETKİ KONTROLÜ
if (!isset($_SESSION['portal_user']['id'])) {
    http_response_code(403);
    exit('Yetkisiz');
}

$userId = (int)$_SESSION['portal_user']['id'];
$db     = DB::get();

// DOSYA KONTROL
if (
    !isset($_FILES['avatar']) ||
    $_FILES['avatar']['error'] !== UPLOAD_ERR_OK
) {
    exit('Dosya yüklenemedi');
}

// MIME KONTROL
$allowed = ['image/png', 'image/jpeg', 'image/jpg'];
if (!in_array($_FILES['avatar']['type'], $allowed)) {
    exit('Geçersiz dosya türü');
}

// BOYUT (2MB)
if ($_FILES['avatar']['size'] > 2 * 1024 * 1024) {
    exit('Dosya çok büyük');
}

// KLASÖR
$uploadDir = __DIR__ . '/../assets/uploads/avatars/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// DOSYA ADI
$ext = pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION);
$filename = 'avatar_' . $userId . '_' . time() . '.' . $ext;
$target   = $uploadDir . $filename;

// TAŞI
if (!move_uploaded_file($_FILES['avatar']['tmp_name'], $target)) {
    exit('Dosya taşınamadı');
}

// DB GÜNCELLE
$avatarPath = 'assets/uploads/avatars/' . $filename;

$stmt = $db->prepare("UPDATE portal_users SET avatar = ? WHERE id = ?");
$stmt->execute([$avatarPath, $userId]);

// SESSION SYNC
$_SESSION['portal_user']['avatar'] = $avatarPath;

// REDIRECT
$redirect = $_POST['redirect'] ?? '/portal/pages/profile.php';
header("Location: " . $redirect);
exit;
