<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$isLoggedIn  = isset($_SESSION['portal_user']);
$currentUser = $isLoggedIn ? $_SESSION['portal_user'] : null;
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($PAGE_TITLE) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Cache bust + doğru path -->
    <link rel="stylesheet" href="/portal/assets/css/portal.css?v=<?= time() ?>">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>

<div class="portal-wrapper">

    <!-- ÜST NAVBAR -->
    <header class="portal-header">
        <div class="portal-logo">
            <a href="index.php">
                <span class="portal-logo-text">NOVAPUS</span>
            </a>
        </div>

        <nav class="portal-nav">
            <a href="index.php?page=home"
               class="nav-link <?= ($page === 'home' || $page === '') ? 'nav-link-active' : '' ?>">Ana Sayfa</a>

            <a href="index.php?page=universes"
               class="nav-link <?= $page === 'universes' ? 'nav-link-active' : '' ?>">Evrenler</a>

            <a href="index.php?page=support"
               class="nav-link <?= $page === 'support' ? 'nav-link-active' : '' ?>">Destek</a>

            <a href="index.php?page=rules"
               class="nav-link <?= $page === 'rules' ? 'nav-link-active' : '' ?>">Kurallar</a>

            <a href="index.php?page=contact"
               class="nav-link <?= $page === 'contact' ? 'nav-link-active' : '' ?>">İletişim</a>

            <a href="index.php?page=forum"
               class="nav-link <?= $page === 'forum' ? 'nav-link-active' : '' ?>">Forum</a>
        </nav>

        <div class="portal-user-area">
            <?php if (!empty($isLoggedIn) && !empty($currentUser)): ?>
                <div class="user-box">
                    <img src="<?= htmlspecialchars($currentUser['avatar'] ?? 'assets/img/default-avatar.png') ?>"
                         class="user-avatar" alt="Avatar">
                    <span class="user-name">
                        <?= htmlspecialchars($currentUser['username'] ?? 'Komutan') ?>
                    </span>
                    <a href="index.php?page=profile" class="btn btn-outline">Profil</a>
                    <a href="logout.php" class="btn btn-ghost">Çıkış</a>
                    <!-- ADIM 2'de gerçek logout olacak -->
                </div>
            <?php else: ?>
                <a href="index.php?page=login"    class="btn btn-ghost">Giriş</a>
                <a href="index.php?page=register" class="btn btn-primary">Kayıt Ol</a>
            <?php endif; ?>
        </div>
    </header>
    <!-- ÜST LOGO + GEZEGEN BANNERI -->
<div class="portal-banner">
    <div class="banner-left">
        <img src="/portal/assets/img/novapus-logo.png" alt="Novapus Logo" class="banner-logo">
    </div>

<div class="banner-right">
    <div class="banner-ring-1"></div>
    <div class="banner-ring-2"></div>
    <div class="banner-planet"></div>
</div>
</div>

    <!-- ANA İÇERİK -->
    <main class="portal-content">