<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

$page   = isset($_GET['page']) ? $_GET['page'] : 'home';

$allowedPages = [
    'home',
    'login',
    'register',
    'profile',
    'universes',
    'support',        // ticket oluşturma formu
    'support_list',   // ticket listesi (AJAX değil!)
    'support_view',   // ticket detay
    'support_send',   // ticket gönderme işlemi
    'rules',
    'contact',
    'forum',
    'play'
];

if (!in_array($page, $allowedPages)) {
    $page = 'home';
}

$PAGE_TITLE = 'Novapus Portal';


// --- ÖN ÇALIŞMASI OLAN SAYFALAR (header/footer içinden çağrılmaz) ---
$preProcessPages = ['login', 'register', 'profile', 'play', 'support_send'];

if (in_array($page, $preProcessPages)) {
    require __DIR__ . '/pages/' . $page . '.php';
    exit;
}


// =======================================================
//  CMS ENTEGRASYONU - HOME SAYFASI İÇİN
// =======================================================

$useCMS = false;
$cmsSections = [];

if ($page === 'home') {

    // CMS dosyası varsa yükle
    if (file_exists(__DIR__ . '/includes/home_cms.php')) {

        require_once __DIR__ . '/includes/db.php';
        require_once __DIR__ . '/includes/home_cms.php';

        $db = DB::get();
        $cmsSections = getPortalPageSections($db, 'home');

        // Eğer CMS içinde aktif bölüm varsa CMS devreye girer
        if (!empty($cmsSections)) {
            $useCMS = true;
        }
    }
}


// =======================================================
//  NORMAL SAYFA AKIŞI
// =======================================================

require __DIR__ . '/includes/header.php';

// Eğer home sayfası CMS tarafından yönetiliyorsa:
if ($page === 'home' && $useCMS === true) {

    // CMS renderer
    require __DIR__ . '/pages/home_cms_render.php';

} else {

    // Normal statik sayfa sistemi
    require __DIR__ . '/pages/' . $page . '.php';
}

require __DIR__ . '/includes/footer.php';
