<?php
// pages/home_cms_render.php
// Bu dosya: CMS aktif olduğunda çalışır.
// Mevcut tasarımı bozmadan blokların yerleşmesini sağlar.
?>

<?php foreach ($cmsSections as $sec): ?>

    <?php if ($sec['type'] === 'hero'): ?>
        <section class="hero-section <?= htmlspecialchars($sec['css_class']) ?>">
            <div class="hero-text hero-main-block">

                <?php if (!empty($sec['subtitle'])): ?>
                    <div class="hero-kicker"><?= htmlspecialchars($sec['subtitle']) ?></div>
                <?php endif; ?>

                <?php if (!empty($sec['title'])): ?>
                    <h1><?= htmlspecialchars($sec['title']) ?></h1>
                <?php endif; ?>

                <?php if (!empty($sec['body'])): ?>
                    <p><?= nl2br(htmlspecialchars($sec['body'])) ?></p>
                <?php endif; ?>

                <?php if (!empty($sec['button_label']) && !empty($sec['button_url'])): ?>
                    <div class="hero-buttons">
                        <a href="<?= htmlspecialchars($sec['button_url']) ?>" class="btn btn-primary hero-cta-main">
                            <?= htmlspecialchars($sec['button_label']) ?>
                        </a>
                    </div>
                <?php endif; ?>

            </div>

            <div class="hero-side">
                <div class="hero-info-box">
                    <h3>Tek Hesap · Tüm Evrenler</h3>
                    <p>Novapus portal hesabınla tüm evrenlerde oyna. Tek tıkla evrene giriş yap.</p>
                </div>
            </div>
        </section>

    <?php elseif ($sec['type'] === 'card'): ?>

        <section class="section custom-card-block <?= htmlspecialchars($sec['css_class']) ?>">
            <div class="section-header">
                <?php if (!empty($sec['subtitle'])): ?>
                    <div class="section-eyebrow"><?= htmlspecialchars($sec['subtitle']) ?></div>
                <?php endif; ?>

                <?php if (!empty($sec['title'])): ?>
                    <h2><?= htmlspecialchars($sec['title']) ?></h2>
                <?php endif; ?>

                <?php if (!empty($sec['body'])): ?>
                    <p><?= nl2br(htmlspecialchars($sec['body'])) ?></p>
                <?php endif; ?>
            </div>

            <?php if (!empty($sec['button_label'])): ?>
                <div class="text-center mt-3">
                    <a href="<?= htmlspecialchars($sec['button_url']) ?>" class="btn btn-outline">
                        <?= htmlspecialchars($sec['button_label']) ?>
                    </a>
                </div>
            <?php endif; ?>
        </section>

    <?php elseif ($sec['type'] === 'text'): ?>

        <section class="section text-block <?= htmlspecialchars($sec['css_class']) ?>">
            <div class="section-header">
                <?php if (!empty($sec['title'])): ?>
                    <h2><?= htmlspecialchars($sec['title']) ?></h2>
                <?php endif; ?>
                <?php if (!empty($sec['body'])): ?>
                    <p><?= nl2br(htmlspecialchars($sec['body'])) ?></p>
                <?php endif; ?>
            </div>
        </section>

    <?php elseif ($sec['type'] === 'survey' && !empty($sec['survey_id'])): ?>

        <?php
        // Anket verilerini çek
        $stmt = $db->prepare("SELECT * FROM portal_surveys WHERE id = ? AND status = 1");
        $stmt->execute([$sec['survey_id']]);
        $survey = $stmt->fetch();

        $opts = [];
        if ($survey) {
            $stmt = $db->prepare("SELECT * FROM portal_survey_options WHERE survey_id = ? ORDER BY sort_order ASC, id ASC");
            $stmt->execute([$survey['id']]);
            $opts = $stmt->fetchAll();
        }
        ?>

        <?php if ($survey): ?>
            <section class="section survey-block <?= htmlspecialchars($sec['css_class']) ?>">
                <div class="section-header">
                    <h2><?= htmlspecialchars($survey['question']) ?></h2>
                </div>

                <div class="survey-options">
                    <?php foreach ($opts as $op): ?>
                        <button class="btn btn-sm btn-outline-light mb-2"
                                onclick="voteSurvey(<?= (int)$op['id'] ?>)">
                            <?= htmlspecialchars($op['option_text']) ?>
                            <span class="badge bg-secondary"><?= (int)$op['votes'] ?></span>
                        </button>
                    <?php endforeach; ?>
                </div>
            </section>
        <?php endif; ?>

    <?php elseif ($sec['type'] === 'html'): ?>

        <section class="section html-block <?= htmlspecialchars($sec['css_class']) ?>">
            <?= $sec['body'] /* raw HTML */ ?>
        </section>

    <?php elseif ($sec['type'] === 'universes'): ?>

        <section class="section universes-preview <?= htmlspecialchars($sec['css_class']) ?>">
            <?php include __DIR__ . '/../includes/universe_list_block.php'; ?>
        </section>

    <?php endif; ?>

<?php endforeach; ?>
