<?php

class ShowTraderPremiumSettingsPage extends AbstractAdminPage
{
    public static $requireModule = 0;

    public function __construct()
    {
        parent::__construct();
    }

    public function save()
    {
        $trade_charge   = HTTP::_GP('trade_charge', 30);
        $premium_factor = HTTP::_GP('premium_factor', 3);
        $active_rates   = HTTP::_GP('active_rates', array());

        // 📌 YENİ ALAN — Temel DM maliyeti
        $base_dm_cost = HTTP::_GP('base_dm_cost', 2500);

        // ✔ Config’e yaz
        Config::get()->trade_charge          = $trade_charge;
        Config::get()->premium_factor        = $premium_factor;
        Config::get()->premium_active_rates  = implode(',', $active_rates);

        // 📌 YENİ SATIR
        Config::get()->base_dm_cost          = $base_dm_cost;

        Config::get()->save();

        $this->printMessage(
            "Ayarlar başarıyla kaydedildi!",
            [['label'=>'Geri Dön','url'=>'admin.php?page=traderPremiumSettings']]
        );
    }

    public function show()
    {
        $this->assign(array(
            'trade_charge'     => Config::get()->trade_charge,
            'premium_factor'   => Config::get()->premium_factor,
            'active_rates'     => explode(',', Config::get()->premium_active_rates),
            'all_rates'        => array(30,40,50,60,70,80,90,100),

            // 📌 YENİ ALAN
            'base_dm_cost'     => Config::get()->base_dm_cost,
        ));

        $this->display('page.traderPremiumSettings.tpl');
    }
}
