// ===============================
// NOVAPUS PORTAL JAVASCRIPT
// - Sol panel login
// - Sağ panel içerik yükleme
// ===============================

/**
 * Sağ panelde içerik yükler.
 * section: 'register' | 'news' | 'lostpassword' | 'about' | 'rules' | 'support'
 */
function PortalLoad(section) {
    var $content = $('#portalContent');

    // Menüde aktif butonu işaretle
    $('.portal-menu-btn').removeClass('active');
    $('.portal-menu-btn').each(function () {
        var text = $(this).text().toLowerCase();
        if (section === 'register' && text.indexOf('kayıt') !== -1) {
            $(this).addClass('active');
        } else if (section === 'news' && text.indexOf('haber') !== -1) {
            $(this).addClass('active');
        } else if (section === 'lostpassword' && text.indexOf('şifre') !== -1) {
            $(this).addClass('active');
        } else if (section === 'about' && text.indexOf('hakkında') !== -1) {
            $(this).addClass('active');
        } else if (section === 'rules' && text.indexOf('kural') !== -1) {
            $(this).addClass('active');
        } else if (section === 'support' && text.indexOf('destek') !== -1) {
            $(this).addClass('active');
        }
    });

    // Yükleniyor yazısı
    $content.html(
        '<div class="text-center fs-5 py-4">Yükleniyor...</div>'
    );

    // AJAX ile içerik çek
    $.ajax({
        url: 'index.php',
        type: 'GET',
        data: {
            page: 'portal',
            mode: section,
            ajax: 1
        },
        success: function (html) {
            $content.html(html);
        },
        error: function () {
            $content.html('<div class="text-danger py-4">İçerik yüklenirken bir hata oluştu.</div>');
        }
    });
}

/**
 * Soldaki login formunu AJAX ile çalıştırır.
 * activeRecaptcha / use_recaptcha_on_login -> Smarty'den string gelir ('1' / '0')
 */
function PortalLogin(activeRecaptcha, use_recaptcha_on_login) {
    var recaptchaResponse = false;

    // Eğer recaptcha aktifse ve sayfada tanımlıysa al
    if (parseInt(activeRecaptcha) === 1 && parseInt(use_recaptcha_on_login) === 1 && typeof grecaptcha !== 'undefined') {
        recaptchaResponse = grecaptcha.getResponse();
    }

    var userEmail  = $('#userEmail').val();
    var password   = $('#password').val();
    var csrfToken  = $('#csrfToken').val();
    var universe   = $('#universe option:selected').val();
    var rememberMe = $('#remember_me').is(':checked');

    // Hata mesajlarını temizle
    $('.alert-portal-login').remove();

    $.ajax({
        type: 'POST',
        url: 'index.php?page=login&mode=validate&ajax=1',
        data: {
            userEmail: userEmail,
            password: password,
            g_recaptcha_response: recaptchaResponse,
            csrfToken: csrfToken,
            remember_me: rememberMe,
            universe: universe
        },
        success: function (data) {
            var dataParsed;
            try {
                dataParsed = $.parseJSON(data);
            } catch (e) {
                console.log('Login JSON parse error', e, data);
                showPortalLoginError('Beklenmeyen bir hata oluştu.');
                return;
            }

            // Hata kontrolü
            if (dataParsed.status === 'fail') {
                if (parseInt(activeRecaptcha) === 1 && parseInt(use_recaptcha_on_login) === 1 && typeof grecaptcha !== 'undefined') {
                    grecaptcha.reset();
                }

                $.each(dataParsed, function (typeError, errorText) {
                    if (typeError === 'status') {
                        return;
                    }
                    showPortalLoginError(errorText);
                });

            } else if (dataParsed.status === 'redirect') {
                // Giriş başarılı → oyuna yönlendir
                window.location.href = 'game.php';
            }
        },
        error: function () {
            showPortalLoginError('Sunucuya bağlanırken bir hata oluştu.');
        }
    });
}

/**
 * Login kutusunun içine hata mesajı basar.
 */
function showPortalLoginError(msg) {
    var $box = $('.portal-login-box');
    if (!$box.length) return;

    var alertHtml =
        '<div class="alert-portal-login" style="margin-top:8px;font-size:13px;color:#ff6969;border:1px solid rgba(255,105,105,0.6);' +
        'background:rgba(50,0,0,0.5);border-radius:6px;padding:6px 8px;text-align:center;">' +
        msg +
        '</div>';

    $box.append(alertHtml);
}