/* Novapus — Modern Fleet Animation (serverTime ile senkron) */

document.addEventListener('DOMContentLoaded', function () {

    // 2Moons'un global zaman değişkenleri, yoksa hiç uğraşmayalım
    if (typeof serverTime === 'undefined' || typeof startTime === 'undefined')
        return;

    var cards = document.querySelectorAll('.nova-fleet-modern-card');
    if (!cards.length) return;

    cards.forEach(function (card) {

        // PHP'den gelen başlangıç kalan süre (resttime)
        var initialRest = Number(card.dataset.rest);

        if (isNaN(initialRest) || initialRest <= 0) {
            var cd0 = card.querySelector('.countdown');
            if (cd0) cd0.textContent = '0 sn';
            return;
        }

        var ship      = card.querySelector('.ship');
        var countdown = card.querySelector('.countdown');

        function formatTime(sec) {
            if (sec < 0) sec = 0;
            sec = Math.floor(sec);

            var h = Math.floor(sec / 3600);
            var m = Math.floor((sec % 3600) / 60);
            var s = sec % 60;

            var txt = "";
            if (h > 0) txt += h + " saat ";
            if (m > 0) txt += m + " dk ";
            txt += s + " sn";
            return txt;
        }

        function tick() {
            // fleetTable.js ile aynı mantık:
            // geçen süre = (şu anki serverTime - sayfa açılış serverTime)
            var passed = (serverTime.getTime() - startTime) / 1000;
            var remaining = initialRest - passed;

            if (remaining < 0) remaining = 0;

            // Sayaç yazısı
            if (countdown) {
                countdown.textContent = formatTime(remaining);
            }

            // Gemi ilerlemesi
            if (ship) {
                var done = (initialRest - remaining) / initialRest;
                if (done < 0) done = 0;
                if (done > 1) done = 1;
                ship.style.left = (done * 100) + '%';
            }
        }

        // İlk çizim + her saniye güncelle
        tick();
        window.setInterval(tick, 1000);
    });
});
/* ============================================
   GEMİ ANİMASYONU (Novapus Modern Fleet)
============================================ */

function animateShip(fleetID, startTS, endTS) {
    const bar = document.getElementById("bar-" + fleetID);
    const ship = document.getElementById("ship-" + fleetID);
    if (!bar || !ship) return;

    const barWidth = bar.offsetWidth;

    function update() {
        const now = Math.floor(Date.now() / 1000);
        let progress = (now - startTS) / (endTS - startTS);

        if (progress < 0) progress = 0;
        if (progress > 1) progress = 1;

        const pos = barWidth * progress;
        ship.style.left = pos + "px";

        requestAnimationFrame(update);
    }

    update();
}

/* Kartları başlat */
document.querySelectorAll(".nova-fleet-modern-card").forEach(card => {
    const fleetID = card.dataset.id || card.getAttribute("data-id");
    const startTS = parseInt(card.dataset.start);
    const endTS = parseInt(card.dataset.end);

    animateShip(fleetID, startTS, endTS);
});
