{block name="content"}

<div class="container mt-4">

    <h2 class="mb-4 text-center fw-bold text-primary">Yeni Subay Ekle</h2>

    <form action="admin.php?page=officers&mode=saveAdd" method="post">

        <div class="row">

            <!-- SOL BLOK -->
            <div class="col-md-6">

                <div class="card mb-3 shadow-sm">
                    <div class="card-header bg-primary text-white fw-bold">
                        Subay Bilgileri
                    </div>

                    <div class="card-body">

                        <div class="mb-3">
                            <label class="form-label fw-bold">Subay Adı</label>
                            <input type="text" name="name" class="form-control" placeholder="ör: Komutan" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Açıklama</label>
                            <textarea name="description" class="form-control" rows="4" placeholder="Subayın açıklaması..."></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Resim Adı</label>
                            <input type="text" name="image" class="form-control" placeholder="ör: komutan.png">
                            <small class="text-muted">
                                Resimleri şu klasöre yükleyebilirsin:<br>
                                <b>styles/theme/gow/img/officers</b>
                            </small>
                        </div>

                    </div>
                </div>

            </div>

            <!-- SAĞ BLOK -->
            <div class="col-md-6">

                <div class="card mb-3 shadow-sm">
                    <div class="card-header bg-success text-white fw-bold">
                        Fiyat & Süre Ayarları
                    </div>

                    <div class="card-body">

                        <div class="mb-3">
                            <label class="form-label fw-bold">Dark Matter Ücreti</label>
                            <input type="number" name="cost_dm" class="form-control" placeholder="ör: 500" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Süre (Saat)</label>
                            <select name="duration_hours" class="form-control">
                                <option value="168">7 Gün (168 Saat)</option>
                                <option value="720">30 Gün (720 Saat)</option>
                                <option value="2160">90 Gün (2160 Saat)</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Aktif/Pasif</label>
                            <select name="active" class="form-control">
                                <option value="1">Aktif</option>
                                <option value="0">Pasif</option>
                            </select>
                        </div>

                    </div>
                </div>

            </div>

        </div>




<!-- SUBAY BONUSLARI -->
<div class="card mt-4 shadow-sm">
    <div class="card-header bg-info text-white fw-bold">
        Subay Bonusları
    </div>

    <div class="card-body">

        <style>
            .bonus-row {
                border: 1px solid #d6e4ff;
                padding: 6px;
                border-radius: 6px;
                margin-bottom: 6px;
                background: #f7faff;
            }
            .bonus-key {
                font-size: 11px;
                font-weight: 700;
                color: #6f7e95;
            }
            .bonus-desc {
                font-size: 15px;
                color: #1a3d7c;
                margin-top: -1px;
                margin-bottom: 8px;
            }
        </style>

        {foreach $BONUS_KEYS as $key => $desc}
        <div class="bonus-row row">

            <!-- Bonus açıklamaları -->
            <div class="col-md-6">
                <div class="bonus-key">{$key}</div>
                <div class="bonus-desc">{$desc}</div>
            </div>

            <!-- Değer girişi -->
            <div class="col-md-6">
                <input type="number"
                    step="0.01"
                    name="bonus_value[{$key}]"
                    class="form-control"
                    placeholder="ör: 0.10">
            </div>

        </div>
        {/foreach}

    </div>
</div>



        <!-- KAYDET BUTONU -->
        <div class="text-center mt-4 mb-5">
            <button class="btn btn-primary btn-lg fw-bold px-5" type="submit">
                + Yeni Subay Ekle
            </button>
        </div>

    </form>

</div>

{/block}
