{block name="content"}

<style>
.table-dark-nova {
    background: #121b27;
    color: #dfe6ef;
    border-radius: 8px;
}
.table-dark-nova thead {
    background: #1f2a38;
}
.table-dark-nova th, .table-dark-nova td {
    padding: 12px;
    vertical-align: middle;
}
.badge-active {
    background: #00c853;
}
.badge-passive {
    background: #ff5252;
}
.officer-img {
    width: 48px;
    height: 48px;
    object-fit: contain;
    border-radius: 6px;
    background: #0c121a;
    padding: 4px;
}
.btn-edit {
    background: #1f8bff;
    color: #fff;
    padding: 6px 14px;
    font-size: 14px;
}
.btn-delete {
    background: #ff4d4d;
    color: #fff;
    padding: 6px 14px;
    font-size: 14px;
}
.add-btn {
    background: #00c853;
    color: #fff;
    padding: 10px 18px;
    font-size: 15px;
    border-radius: 6px;
}
.bonus-badge {
    background: #2d3b4d;
    color: #9cc7ff;
    font-size: 12px;
    padding: 4px 7px;
    border-radius: 4px;
    margin-right: 5px;
}
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="text-white fw-bold">Subay Yönetimi</h2>
    <!-- BURASI DÜZELTİLDİ: action → mode -->
    <a href="admin.php?page=officers&mode=add" class="add-btn text-decoration-none">
        + Yeni Subay Ekle
    </a>
</div>

<table class="table table-dark-nova w-100">
    <thead>
        <tr>
            <th>ID</th>
            <th>Resim</th>
            <th>Ad</th>
            <th>DM Fiyatı</th>
            <th>Süre</th>
            <th>Bonuslar</th>
            <th>Durum</th>
            <th style="width:160px">İşlemler</th>
        </tr>
    </thead>

    <tbody>
        {foreach $officers as $o}
        <tr>
            <td>{$o.id}</td>

            <td>
                <img src="styles/theme/gow/img/officers/{$o.image}" class="officer-img">
            </td>

            <td>{$o.name}</td>

            <td>{$o.cost_dm} DM</td>

            <td>
                {if $o.duration_hours == 168}7 Gün
                {elseif $o.duration_hours == 720}30 Gün
                {elseif $o.duration_hours == 2160}90 Gün
                {else}{$o.duration_hours} Saat{/if}
            </td>

            <td>
                {foreach $o.bonuses as $b}
                    <span class="bonus-badge">
                        {$b.effect_key}: {$b.effect_value}
                    </span>
                {/foreach}
            </td>

            <td>
                {if $o.active == 1}
                    <span class="badge badge-active">Aktif</span>
                {else}
                    <span class="badge badge-passive">Pasif</span>
                {/if}
            </td>

            <td>
                <!-- BURASI DÜZELTİLDİ: action → mode -->
                <a href="admin.php?page=officers&mode=edit&id={$o.id}" class="btn btn-edit">Düzenle</a>
                <!-- BURASI DÜZELTİLDİ: action → mode -->
                <a href="admin.php?page=officers&mode=delete&id={$o.id}" class="btn btn-delete"
                   onclick="return confirm('Bu subayı silmek istediğine emin misin?')">
                    Sil
                </a>
            </td>
        </tr>
        {/foreach}
    </tbody>
</table>

{/block}
