{block name="title" prepend}{$LNG.siteTitleIndex}{/block}
{block name="content"}

<script type="text/javascript">
// this is the id of the form
function loginSubmit(activeRecaptcha,use_recaptcha_on_login){
    var recaptchaResponse = false;

    if (activeRecaptcha == 1 && use_recaptcha_on_login == 1) {
        recaptchaResponse = grecaptcha.getResponse();
    }

    $.ajax({
        type: "POST",
        url: 'index.php?page=login&mode=validate&ajax=1',
        data: {
            userEmail: $("#userEmail").val(),
            password: $("#password").val(),
            g_recaptcha_response: recaptchaResponse,
            csrfToken: $('#csrfToken').val(),
            remember_me : $('#remember_me').is(':checked'),
            universe : $('#universe option:selected').val(),
            rememberedTokenValidator : $('#rememberedTokenValidator').val(),
            rememberedTokenSelector : $('#rememberedTokenSelector').val(),
            rememberedEmail : $('#rememberedEmail').val()
        },
        success: function(data)
        {
            var dataParsed = jQuery.parseJSON(data);
            $('.alert').remove();

            if (dataParsed.status == 'fail') {
                if (activeRecaptcha == 1 && use_recaptcha_on_login == 1) {
                    grecaptcha.reset();
                }

                $.each( dataParsed, function( typeError, errorText ) {
                    if (typeError == 'status') {
                        return;
                    }
                    $('#loginButton').before("<span class='alert alert-danger fs-6 py-1 my-1 w-100 d-block text-center'>"+ errorText +"</span>")
                });

            } else if (dataParsed.status == 'redirect') {
                location.href = "game.php";
            }
        }
    });
}
</script>

<style>
/* ===== NOVAPUS LOGIN V2 – HOLOGRAM BIG PANEL ===== */

.nova-login-bg{
    min-height: 100vh;
    width: 100%;
    padding: 40px 16px;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    background:
        radial-gradient(circle at 10% 0%, rgba(76,194,255,0.18), transparent 55%),
        radial-gradient(circle at 90% 100%, rgba(161,108,255,0.2), transparent 55%),
        linear-gradient(160deg,#050712,#090b18 40%,#100c1d);
}

/* yıldız efekti */
.nova-login-bg::before{
    content:"";
    position:absolute;
    inset:0;
    background-image:
        radial-gradient(1px 1px at 15% 20%, rgba(255,255,255,0.6), transparent),
        radial-gradient(1px 1px at 70% 35%, rgba(255,255,255,0.4), transparent),
        radial-gradient(1px 1px at 30% 80%, rgba(255,255,255,0.5), transparent),
        radial-gradient(1px 1px at 85% 65%, rgba(255,255,255,0.45), transparent);
    opacity:.25;
    pointer-events:none;
}

/* hafif yatay ışık çizgisi */
.nova-login-lightbar{
    position:absolute;
    top:12%;
    left:50%;
    transform:translateX(-50%);
    width: 90%;
    max-width: 980px;
    height: 2px;
    background:linear-gradient(90deg,transparent,#4CC2FF,#A16CFF,transparent);
    opacity:.55;
    box-shadow:0 0 16px rgba(76,194,255,0.8);
}

/* merkez konteyner */
.nova-login-shell{
    position:relative;
    z-index:2;
    width:100%;
    max-width: 920px;
    display:flex;
    flex-direction:column;
    align-items:center;
    gap:22px;
    text-align:center;
}

/* başlık alanı */
.nova-login-heading{
    color:#ecf2ff;
}
.nova-login-title{
    font-size:2.2rem;
    font-weight:700;
    text-shadow:0 0 18px rgba(76,194,255,0.7);
}
.nova-login-sub{
    margin-top:10px;
    max-width:620px;
    margin-left:auto;
    margin-right:auto;
    font-size:.96rem;
    color:#a8b5dd;
}
.nova-login-tags{
    margin-top:14px;
    display:flex;
    flex-wrap:wrap;
    justify-content:center;
    gap:8px;
}
.nova-tag{
    font-size:.76rem;
    padding:4px 10px;
    border-radius:999px;
    border:1px solid rgba(76,194,255,0.55);
    color:#d7e5ff;
    background:linear-gradient(135deg,rgba(76,194,255,0.12),rgba(161,108,255,0.1));
    backdrop-filter:blur(10px);
}

/* büyük hologram panel */
.nova-login-panel{
    position:relative;
    width:100%;
    max-width:560px; /* A2: büyük panel */
    margin-left:auto;
    margin-right:auto;
    border-radius:26px;
    padding:22px 24px 18px;
    background:
        radial-gradient(circle at top left, rgba(76,194,255,0.18), transparent 55%),
        radial-gradient(circle at bottom right, rgba(161,108,255,0.2), transparent 55%),
        rgba(7,9,18,0.94);
    border:1px solid rgba(255,255,255,0.14);
    box-shadow:
        0 0 0 1px rgba(76,194,255,0.22),
        0 20px 60px rgba(1,3,15,0.96);
    backdrop-filter:blur(18px);
}

/* hologram dış çerçeve */
.nova-login-panel::before{
    content:"";
    position:absolute;
    inset:-1px;
    border-radius:26px;
    padding:1px;
    background:
        linear-gradient(135deg,rgba(76,194,255,0.8),rgba(161,108,255,0.8));
    -webkit-mask:
        linear-gradient(#000 0 0) content-box,
        linear-gradient(#000 0 0);
    -webkit-mask-composite:xor;
            mask-composite:exclude;
    opacity:.45;
    pointer-events:none;
}

/* panel üst başlık */
.nova-panel-header{
    display:flex;
    align-items:center;
    justify-content:space-between;
    margin-bottom:10px;
}
.nova-panel-title{
    font-size:1.02rem;
    font-weight:600;
    color:#f0f4ff;
}
.nova-panel-caption{
    font-size:.78rem;
    color:#8e9ac0;
}
.nova-panel-orbit{
    width:56px;
    height:18px;
    border-radius:999px;
    border:1px solid rgba(76,194,255,0.7);
    display:flex;
    align-items:center;
    justify-content:center;
    font-size:.68rem;
    color:#d7e6ff;
    background:radial-gradient(circle at 20% 0%,rgba(76,194,255,0.5),transparent 65%);
    box-shadow:0 0 10px rgba(76,194,255,0.8);
}

/* form alanı */
.nova-login-panel .form-control,
.nova-login-panel .form-select{
    font-size:.9rem;
    background:rgba(6,8,16,0.98);
    border-radius:999px;
    border:1px solid rgba(119,142,194,0.7);
    color:#e7edff;
    padding:9px 14px;
}
.nova-login-panel .form-control:focus,
.nova-login-panel .form-select:focus{
    border-color:#4CC2FF;
    box-shadow:0 0 0 1px rgba(76,194,255,0.6);
    outline:none;
}

/* etiketler */
.nova-input-label{
    font-size:.78rem;
    color:#8ea0cf;
    text-align:left;
    margin-left:4px;
    margin-bottom:2px;
}

/* remember alanı */
.nova-remember-wrap{
    display:flex;
    align-items:center;
    justify-content:space-between;
    margin-top:4px;
    margin-bottom:6px;
}
.nova-remember-text{
    font-size:.8rem;
    color:#b9c6ea;
}
.nova-helper-link{
    font-size:.78rem;
    color:#93b8ff;
    text-decoration:none;
}
.nova-helper-link:hover{
    text-decoration:underline;
}

/* butonlar */
.nova-btn-primary{
    border-radius:999px;
    font-size:.94rem;
    font-weight:600;
    border:none;
    background:linear-gradient(135deg,#4CC2FF,#A16CFF);
    color:#05060a !important;
    box-shadow:0 0 22px rgba(76,194,255,0.9);
}
.nova-btn-primary:hover{
    filter:brightness(1.08);
}

.nova-btn-secondary{
    border-radius:999px;
    font-size:.85rem;
    font-weight:500;
    border:1px solid rgba(138,156,210,0.9);
    background:rgba(6,8,16,0.98);
    color:#e1ebff !important;
}
.nova-btn-secondary:hover{
    border-color:#4CC2FF;
}

/* facebook alanı */
.nova-fb-wrapper{
    margin-top:8px;
    margin-bottom:4px;
}

/* recaptcha kutusu */
.nova-recaptcha-wrapper{
    width:100%;
    overflow:hidden;
}

/* panel alt bilgi */
.nova-panel-footer{
    font-size:.78rem;
    color:#808bb1;
    margin-top:6px;
}

/* mobil uyum */
@media (max-width: 767.98px){
    .nova-login-bg{
        padding-top:30px;
        padding-bottom:30px;
    }
    .nova-login-title{
        font-size:1.7rem;
    }
    .nova-login-panel{
        padding:18px 16px 14px;
        border-radius:20px;
    }
    .nova-login-panel::before{
        border-radius:20px;
    }
}
</style>

<div class="nova-login-bg">
    <div class="nova-login-lightbar"></div>

    <div class="nova-login-shell">

        <!-- BAŞLIK ALANI -->
        <div class="nova-login-heading">
            <h1 class="nova-login-title">
                {sprintf($LNG.loginWelcome, $gameName)}
            </h1>
            <p class="nova-login-sub">
                {sprintf($LNG.loginServerDesc, $gameName)}
            </p>

            <div class="nova-login-tags">
                <span class="nova-tag">⚡ Hızlandırılmış başlangıç</span>
                <span class="nova-tag">💎 Gelişmiş karanlık madde sistemi</span>
                <span class="nova-tag">🛰 Gerçek zamanlı uzay filoları</span>
                <span class="nova-tag">🌌 Derin araştırma ve teknoloji ağacı</span>
            </div>
        </div>

        <!-- HOLOGRAM LOGIN PANELİ -->
        <div class="nova-login-panel">

            <div class="nova-panel-header">
                <div>
                    <div class="nova-panel-title">{$LNG.loginHeader}</div>
                    <div class="nova-panel-caption">{if $loginInfo}{$loginInfo}{/if}</div>
                </div>
                <div class="nova-panel-orbit">NOVAPUS</div>
            </div>

            <form id="login" action="" method="post" class="mt-1">
                <input id="csrfToken" type="hidden" name="csrfToken" value="{$csrfToken}">
                <input id="rememberedEmail" type="hidden" name="rememberedEmail" value="{$rememberedEmail}">
                <input id="rememberedTokenSelector" type="hidden" name="rememberedTokenSelector" value="{$rememberedTokenSelector}">
                <input id="rememberedTokenValidator" type="hidden" name="rememberedTokenValidator" value="{$rememberedTokenValidator}">

                <div class="d-flex flex-column form-group">

                    <!-- EVREN -->
                    <label class="nova-input-label" for="universe">{$LNG.universe}</label>
                    <select class="form-select my-1 w-100" name="uni" id="universe">
                        {foreach $universeSelect as $universeID => $currentUniverse}
                            <option class="fs-6" {if $currentUniverse == $rememberedUniverseID}selected{/if} value="{$universeID}">
                                {$currentUniverse}
                            </option>
                        {/foreach}
                    </select>

                    <!-- EMAIL -->
                    <label class="nova-input-label mt-2" for="userEmail">{$LNG.login_email}</label>
                    <input class="form-control fs-6 my-1 w-100"
                           id="userEmail"
                           type="text"
                           name="userEmail"
                           placeholder="{$LNG.login_email}"
                           value="{if !empty($rememberedEmail) && $rememberedEmail}{$rememberedEmail}{/if}">

                    <!-- ŞİFRE -->
                    <label class="nova-input-label mt-2" for="password">{$LNG.loginPassword}</label>
                    <input class="form-control fs-6 my-1 w-100"
                           id="password"
                           type="password"
                           name="password"
                           placeholder="{$LNG.loginPassword}"
                           value="{if $rememberedPassword}password{/if}">

                    <!-- RECAPTCHA -->
                    {if $recaptchaEnable && $use_recaptcha_on_login}
                        <div class="g-recaptcha form-group fs-6 my-2 mx-auto d-flex justify-content-start nova-recaptcha-wrapper"
                             data-sitekey="{$recaptchaPublicKey}"></div>
                    {/if}

                    <!-- REMEMBER + ŞİFREMİ UNUTTUM -->
                    <div class="nova-remember-wrap">
                        <div class="d-flex align-items-center">
                            <input id="remember_me" type="checkbox" name="remember_me" {if $rememberedPassword}checked{/if} value="">
                            <span class="nova-remember-text ms-2">Remember me</span>
                        </div>

                        {if $mailEnable}
                            <a class="nova-helper-link" href="index.php?page=lostPassword">
                                {$LNG.buttonLostPassword}
                            </a>
                        {/if}
                    </div>

                    <!-- GİRİŞ BUTONU -->
                    <button id="loginButton"
                            class="btn nova-btn-primary w-100 my-2"
                            type="button"
                            onclick="loginSubmit(activeRecaptcha = '{$recaptchaEnable}', use_recaptcha_on_login = '{$use_recaptcha_on_login}');">
                        {$LNG.loginButton}
                    </button>

                </div>
            </form>

            <!-- FACEBOOK LOGIN -->
            {if $facebookEnable}
                <div class="nova-fb-wrapper text-center">
                    <a href="#"
                       data-href="index.php?page=externalAuth&method=facebook"
                       class="fb_login d-inline-block">
                        <img src="styles/resource/images/facebook/fb-connect-large.png" alt="Facebook Connect">
                    </a>
                </div>
            {/if}

            <!-- KAYIT BUTONU -->
            <a class="btn nova-btn-secondary w-100 mt-2"
               href="index.php?page=register">
                {$LNG.buttonRegister}
            </a>

            <!-- ALT BİLGİ -->
            <div class="nova-panel-footer text-center">
                {$loginInfo}
            </div>
        </div>
    </div>
</div>

{/block}

{if $recaptchaEnable && $use_recaptcha_on_login}
    {block name="script" append}
        <script type="text/javascript" src="https://www.google.com/recaptcha/api.js?hl=tr"></script>
    {/block}

    {block name="script" append}
        <script type="text/javascript" src="./scripts/base/avoid_submit_on_refresh.js"></script>
    {/block}
{/if}