{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== ANA KART ===== */
.nova-card{
    width: 100%;
    max-width: 760px;
    margin: 0 auto 25px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 18px;
    font-weight: bold;
    color:#9fc5ff;
    margin-bottom: 20px;
    text-align:center;
}

/* Label */
.nova-label{
    color:#c8d8ff;
    font-size: 14px;
    margin-bottom:6px;
    display:block;
}

/* Select */
.nova-select{
    width:100%;
    background:rgba(20,25,40,0.85);
    border:1px solid rgba(140,170,255,0.35);
    border-radius:10px;
    color:#fff;
    padding:8px 12px;
    height:38px;
}

/* Textarea */
.nova-textarea{
    width:100%;
    background:rgba(20,25,40,0.85);
    border:1px solid rgba(140,170,255,0.35);
    border-radius:10px;
    color:#fff;
    padding:10px;
    font-size:13px;
}

/* Grid */
.nova-grid{
    display:grid;
    grid-template-columns:1fr 2fr;
    gap:16px 20px;
}

/* Butonlar */
.nova-btn{
    background:linear-gradient(90deg,#3a7bff,#5ea0ff);
    border:none;
    border-radius:10px;
    padding:8px 18px;
    color:#fff;
    font-weight:bold;
    cursor:pointer;
    transition:.2s;
    margin-right:10px;
}
.nova-btn:hover{
    transform:translateY(-2px);
    box-shadow:0 0 8px rgba(120,150,255,.6);
}

.nova-btn-reset{
    background:#a0a0a0;
    border:none;
    border-radius:10px;
    padding:8px 18px;
    color:#fff;
    font-weight:bold;
    cursor:pointer;
    transition:.2s;
}
.nova-btn-reset:hover{
    background:#b5b5b5;
}
</style>

<div class="nova-card">

    <div class="nova-card-title">{$LNG.al_circular_send_ciruclar}</div>

    <form id="message" name="message">

        <div class="nova-grid">

            <!-- Alliance select -->
            <div class="nova-label">{$LNG.al_diplo_ally}</div>
            <div>
                {html_options name="ally_id" values=$IdList output=$AllyList class="nova-select"}
            </div>

            <!-- Level select -->
            <div class="nova-label">{$LNG.al_diplo_level_des}</div>
            <div>
                {html_options name="level" values=range(1,6) output=$LNG.al_diplo_level selected=$diploMode class="nova-select"}
            </div>

            <!-- Textarea -->
            <div class="nova-label">
                {$LNG.al_diplo_text} <br>
                <span id="cntChars">0</span> / 5000 {$LNG.al_characters}
            </div>
            <div>
                <textarea 
                    name="text" 
                    rows="10" 
                    class="nova-textarea"
                    onkeyup="$('#cntChars').text($(this).val().length);"
                ></textarea>
            </div>

        </div>

        <div style="text-align:center;margin-top:20px;">
            <button type="reset" class="nova-btn-reset">{$LNG.al_circular_reset}</button>
            <button type="button" class="nova-btn" onclick="return check();">{$LNG.al_circular_send_submit}</button>
        </div>
    </form>

</div>

{/block}

{block name="script" append}
<script>
function check(){
    if(document.message.text.value == '') {
        alert('{$LNG.mg_empty_text}');
        return false;
    } else {
        $.getJSON(
            'game.php?page=alliance&mode=admin&action=diplomacyCreateProcessor&ajax=1&' + 
            $('#message').serialize(),
            function(data){
                alert(data.message);
                if(!data.error){
                    parent.location.reload();
                }
            }
        );
        return true;
    }
}

$(function(){
    $('#name').autocomplete({
        source: "game.php?page=search&mode=autocomplete&type=allyname",
        minLength: 0,
        select: function(event, ui){
            $(event.target).val(ui.item.label.replace(/<\/?b>/gim, ''));
            return false;
        }
    });
});
</script>
{/block}
