{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== CARD ===== */
.nova-card{
    width: 100%;
    max-width: 880px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.22);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}

/* Titles */
.nova-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    text-align:center;
    margin-bottom:15px;
}

.nova-subtitle{
    margin-top:20px;
    margin-bottom:8px;
    color:#b5ccff;
    font-weight:bold;
    font-size:15px;
}

/* Alliance list rows */
.nova-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:10px 0;
    border-bottom:1px solid rgba(120,150,255,0.15);
}
.nova-row:last-child{
    border-bottom:none;
}

.nova-name{
    color:#e2eaff;
    font-size:14px;
    font-weight:bold;
}

/* Buttons */
.nova-btn-icon{
    width:26px;
    height:26px;
    border-radius:6px;
    display:flex;
    align-items:center;
    justify-content:center;
    cursor:pointer;
    transition:.2s;
}

.nova-btn-delete{
    background:rgba(160,50,50,0.8);
}
.nova-btn-delete:hover{
    background:rgba(200,60,60,0.95);
}

.nova-btn-accept{
    background:rgba(60,160,70,0.8);
}
.nova-btn-accept:hover{
    background:rgba(60,200,80,0.95);
}

/* Create diplomacy button */
.nova-create{
    display:block;
    text-align:center;
    background:linear-gradient(90deg,#3a7bff,#5ea0ff);
    padding:10px;
    border-radius:10px;
    margin-top:15px;
    color:#fff;
    font-weight:bold;
    transition:.2s;
}
.nova-create:hover{
    box-shadow:0 0 8px rgba(120,150,255,0.6);
    transform:translateY(-2px);
}

/* Back */
.nova-back{
    display:block;
    margin-top: 15px;
    text-align:center;
    background:rgba(40,50,80,0.7);
    padding:10px;
    border-radius:10px;
    border:1px solid rgba(120,150,255,0.35);
    font-weight:bold;
    color:#cfe0ff;
    transition:.2s;
}
.nova-back:hover{
    background:rgba(70,100,150,0.85);
    color:#fff;
}
</style>


<!-- =====================  BÖLÜM 1: Aktif Diplomasi  ===================== -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_diplo_head}</div>

    <div class="nova-box">{$LNG.al_diplo_info}</div>

    {foreach $diploList.0 as $diploMode => $diploAlliances}

        <div class="nova-subtitle">{$LNG.al_diplo_level.$diploMode}</div>

        {foreach $diploAlliances as $diploID => $diploName}
        <div class="nova-row">
            <div class="nova-name">{$diploName}</div>

            <a href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacyDelete&amp;id={$diploID}"
               onclick="return confirm('{$LNG.al_diplo_confirm_delete}');"
               class="nova-btn-icon nova-btn-delete">
                <img src="styles/resource/images/false.png" width="16" height="16">
            </a>
        </div>
        {foreachelse}
        <div class="nova-row"><div class="nova-name">{$LNG.al_diplo_no_entry}</div></div>
        {/foreach}

        <!-- Create new diplomacy button -->
        <a class="nova-create"
           href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacyCreate&amp;diploMode={$diploMode}"
           onclick="return Dialog.open(this.href, 650, 300);">
           {$LNG.al_diplo_create}
        </a>

    {/foreach}
</div>


<!-- =====================  BÖLÜM 2: Gelen Diplomasi Talepleri ===================== -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_diplo_accept}</div>

    {if array_filter($diploList.1)}

        {foreach $diploList.1 as $diploMode => $diploAlliances}
        {if !empty($diploAlliances)}

        <div class="nova-subtitle">{$LNG.al_diplo_level.$diploMode}</div>

        {foreach $diploAlliances as $diploID => $diploName}
        <div class="nova-row">
            <div class="nova-name">{$diploName}</div>

            <div style="display:flex;gap:6px;">
                <!-- Accept -->
                <a href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacyAccept&amp;id={$diploID}"
                   onclick="return confirm('{$LNG.al_diplo_accept_yes_confirm}');"
                   class="nova-btn-icon nova-btn-accept">
                    <img src="styles/resource/images/true.png" width="16" height="16">
                </a>

                <!-- Decline -->
                <a href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacyDelete&amp;id={$diploID}"
                   onclick="return confirm('{$LNG.al_diplo_accept_no_confirm}');"
                   class="nova-btn-icon nova-btn-delete">
                    <img src="styles/resource/images/false.png" width="16" height="16">
                </a>
            </div>
        </div>
        {/foreach}

        {/if}
        {/foreach}

    {else}
        <div class="nova-row"><div class="nova-name">{$LNG.al_diplo_no_accept}</div></div>
    {/if}
</div>


<!-- =====================  BÖLÜM 3: Gönderilen Diplomasi Talepleri ===================== -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_diplo_accept_send}</div>

    {if array_filter($diploList.2)}

        {foreach $diploList.2 as $diploMode => $diploAlliances}
        {if !empty($diploAlliances)}

        <div class="nova-subtitle">{$LNG.al_diplo_level.$diploMode}</div>

        {foreach $diploAlliances as $diploID => $diploName}
        <div class="nova-row">
            <div class="nova-name">{$diploName}</div>

            <!-- Only delete -->
            <a href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacyDelete&amp;id={$diploID}"
               onclick="return confirm('{$LNG.al_diplo_confirm_delete}');"
               class="nova-btn-icon nova-btn-delete">
                <img src="styles/resource/images/false.png" width="16" height="16">
            </a>
        </div>
        {/foreach}

        {/if}
        {/foreach}

    {else}
        <div class="nova-row"><div class="nova-name">{$LNG.al_diplo_no_accept}</div></div>
    {/if}

    <a class="nova-back" href="game.php?page=alliance&amp;mode=admin">{$LNG.al_back}</a>
</div>

{/block}
