{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== Header ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== Card wrap ===== */
.nova-card{
    width: 100%;
    max-width: 1100px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.22);
    border-radius: 14px;
    padding: 20px;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}

/* Title */
.nova-title{
    font-size: 20px;
    font-weight: bold;
    text-align: center;
    color: #a9c8ff;
    margin-bottom: 20px;
}

/* Table modern */
.nova-table{
    width: 100%;
    border-collapse: separate;
    border-spacing: 0 6px;
}

.nova-table thead th{
    padding: 10px;
    background: rgba(40,50,80,0.7);
    font-size: 12px;
    color: #d8e4ff;
    text-align:center;
}

.nova-row{
    background: rgba(20,25,40,0.55);
    border: 1px solid rgba(120,150,255,0.15);
    border-radius: 10px;
    transition: .2s;
}
.nova-row:hover{
    background: rgba(40,50,80,0.65);
}

/* Cells */
.nova-table td{
    padding: 10px 8px;
    font-size: 12px;
    color: #dbe4ff;
    text-align: center;
}

/* Username link */
.nova-user{
    font-weight: bold;
    color: #9fc5ff;
    text-decoration:none;
}
.nova-user:hover{
    color:#b8d6ff;
}

/* Status colors */
.nova-online  { color: #4dff4d; font-weight:bold; }
.nova-idle    { color: #ffe04d; font-weight:bold; }
.nova-offline { color: #ff4d4d; font-weight:bold; }

/* Kick button */
.nova-kick{
    display:inline-flex;
    align-items:center;
    justify-content:center;
    width:24px;
    height:24px;
    background:rgba(180,40,40,0.75);
    border-radius:6px;
    cursor:pointer;
    transition:.2s;
}
.nova-kick:hover{
    background:rgba(210,60,60,0.9);
}

/* Back button */
.nova-back{
    display:block;
    margin-top:20px;
    text-align:center;
    padding:10px;
    border-radius:10px;
    background:rgba(50,60,90,0.65);
    color:#dae4ff;
    border:1px solid rgba(120,150,255,0.22);
    font-weight:bold;
    transition:.2s;
}
.nova-back:hover{
    background:rgba(70,100,150,0.85);
    color:white;
}
</style>


<div class="nova-card">
    <div class="nova-title">{$al_users_list}</div>

<form action="game.php?page=alliance&amp;mode=admin&amp;action=membersSave" method="post">

<table id="memberList" class="nova-table tablesorter">

    <thead>
        <tr>
            <th>{$LNG.al_num}</th>
            <th>{$LNG.al_member}</th>
            <th>{$LNG.al_message}</th>
            <th>{$LNG.al_position}</th>
            <th>{$LNG.al_points}</th>
            <th>{$LNG.al_coords}</th>
            <th>{$LNG.al_member_since}</th>
            <th>{$LNG.al_estate}</th>
            <th>{$LNG.al_actions}</th>
        </tr>
    </thead>

    <tbody>
    {foreach $memberList as $userID => $memberListRow}
        <tr class="nova-row">

            <!-- Row number -->
            <td>{$memberListRow@iteration}</td>

            <!-- Username + status -->
            <td>
                <a href="#" class="nova-user"
                   onclick="return Dialog.Playercard({$userID},'{$memberListRow.username}');">
                    {$memberListRow.username}
                </a>
                {if !empty($memberListRow.class)}
                    {foreach $memberListRow.class as $class}
                        <span class="galaxy-short-{$class} galaxy-short">{$ShortStatus.$class}</span>
                    {/foreach}
                {/if}
            </td>

            <!-- PM -->
            <td>
                <a href="#" onclick="return Dialog.PM({$userID});">
                    <img src="{$dpath}img/m.gif" title="{$LNG.write_message}">
                </a>
            </td>

            <!-- Rank selector -->
            <td>
                {if $memberListRow.rankID == -1}
                    {$founder}
                {elseif !empty($rankSelectList)}
                    {html_options class="rankSelect" name="rank[{$userID}]" options=$rankSelectList selected=$memberListRow.rankID}
                {else}
                    {$rankList[$memberListRow.rankID]}
                {/if}
            </td>

            <!-- Points -->
            <td>
                <span title="{$memberListRow.points|number}">
                    {shortly_number($memberListRow.points)}
                </span>
            </td>

            <!-- Coords -->
            <td>
                <a href="game.php?page=galaxy&amp;galaxy={$memberListRow.galaxy}&amp;system={$memberListRow.system}">
                    [{$memberListRow.galaxy}:{$memberListRow.system}:{$memberListRow.planet}]
                </a>
            </td>

            <!-- Registered -->
            <td>{$memberListRow.register_time}</td>

            <!-- Online status -->
            <td>
                {if $rights.ONLINESTATE}
                    {if $memberListRow.onlinetime < 4}
                        <span class="nova-online">{$LNG.al_memberlist_on}</span>
                    {elseif $memberListRow.onlinetime >=4 && $memberListRow.onlinetime <=15}
                        <span class="nova-idle">{$memberListRow.onlinetime} {$LNG.al_memberlist_min}</span>
                    {else}
                        <span class="nova-offline">{$LNG.al_memberlist_off}</span>
                    {/if}
                {else}-{/if}
            </td>

            <!-- Kick button -->
            <td>
                {if $memberListRow.rankID != -1 && $canKick}
                    <a href="game.php?page=alliance&amp;mode=admin&amp;action=membersKick&amp;id={$userID}"
                       onclick="return confirm('{$memberListRow.kickQuestion}');"
                       class="nova-kick">
                        <img src="{$dpath}pic/abort.gif" width="14" height="14">
                    </a>
                {else}-{/if}
            </td>

        </tr>
    {/foreach}
    </tbody>

</table>

</form>

<a class="nova-back" href="game.php?page=alliance&amp;mode=admin">{$LNG.al_back}</a>

</div>


{/block}

{block name="script" append}
<script src="scripts/base/jquery.tablesorter.js"></script>
<script>
$(function() {

    $.tablesorter.addParser({
        id: 'nopoint',
        is: function(){ return false; },
        format: function(s){
            return parseFloat(s.replace('.',''));
        },
        type: 'numeric'
    });

    $("#memberList").tablesorter({
        headers: {
            0: { sorter:false },
            3: { sorter:false },
            4: { sorter:"nopoint" },
            9: { sorter:false }
        }
    });

    $('.rankSelect').on('change', function(){
        $.post(
            'game.php?page=alliance&mode=admin&action=rank&ajax=1',
            $(this).serialize(),
            function(data){ NotifyBox(data); },
            'json'
        );
    });

});
</script>
{/block}
