{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== KART TASARIMI ===== */
.nova-card{
    width: 100%;
    max-width: 780px;
    margin: 0 auto;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 17px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 22px;
    text-align: center;
}

/* Label */
.nova-label{
    color: #c8d8ff;
    font-size: 14px;
    margin-bottom: 6px;
    display: block;
}

/* Text input */
.nova-input{
    width: 100%;
    height: 36px;
    background: rgba(20,25,40,0.85);
    border: 1px solid rgba(140,170,255,0.35);
    border-radius: 10px;
    padding: 6px 10px;
    color: #fff;
}

/* Textarea */
.nova-textarea{
    width: 100%;
    min-height: 180px;
    background: rgba(20,25,40,0.85);
    border: 1px solid rgba(140,170,255,0.35);
    border-radius: 12px;
    padding: 10px;
    color: #fff;
    resize: vertical;
}

/* Select dropdown */
.nova-select{
    width: 100%;
    height: 36px;
    background: rgba(20,25,40,0.85);
    border: 1px solid rgba(140,170,255,0.35);
    border-radius: 10px;
    padding-left: 8px;
    color: #fff;
}

/* Karakter sayacı */
.char-counter{
    font-size: 12px;
    color: #9fc5ff;
}

/* Butonlar */
.nova-btn{
    border: none;
    border-radius: 10px;
    padding: 8px 20px;
    font-weight: bold;
    cursor: pointer;
    transition: .2s;
    margin: 5px;
}
.nova-btn-reset{
    background: rgba(255,255,255,0.12);
    color: #fff;
}
.nova-btn-reset:hover{
    background: rgba(255,255,255,0.25);
}
.nova-btn-send{
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    color: #fff;
}
.nova-btn-send:hover{
    transform: translateY(-2px);
    box-shadow: 0 0 8px rgba(130,160,255,0.65);
}

</style>

<div class="nova-card">
    <div class="nova-card-title">{$LNG.al_circular_send_ciruclar}</div>

    <form name="message" id="message">

        <!-- RANK SEÇİMİ -->
        <label class="nova-label">{$LNG.al_receiver}</label>
        {html_options name=rankID class="nova-select" options=$RangeList}
        <br><br>

        <!-- KONU -->
        <label class="nova-label">{$LNG.mg_subject}</label>
        <input type="text" name="subject" id="subject" maxlength="40" class="nova-input" value="{$LNG.mg_no_subject}">
        <br><br>

        <!-- MESAJ -->
        <label class="nova-label">
            {$LNG.al_message}
            <span class="char-counter">(<span id="cntChars">0</span> / 5000 {$LNG.al_characters})</span>
        </label>

        <textarea class="nova-textarea" name="text" 
                  onkeyup="$('#cntChars').text($(this).val().length);"></textarea>

        <div class="text-center mt-3">
            <input type="reset" class="nova-btn nova-btn-reset" value="{$LNG.al_circular_reset}">
            <input type="button" onclick="return check();" class="nova-btn nova-btn-send" value="{$LNG.al_circular_send_submit}">
        </div>

    </form>
</div>

{/block}


{block name="script" append}
<script type="text/javascript">
function check(){
	if(document.message.text.value == '') {
		alert('{$LNG.mg_empty_text}');
		return false;
	} else {
		$.post('game.php?page=alliance&mode=circular&action=send&ajax=1',
            $('#message').serialize(),
            function(data){
			    data = $.parseJSON(data);
			    alert(data.message);
			    if(!data.error) {
				    parent.$.fancybox.close();
			    }
		    }
        );
		return true;
	}
}
</script>
{/block}
