{block name="title" prepend}{$LNG.lm_fleet}{/block}
{block name="content"}

<!-- Filo Header Görseli -->
<div class="fleet-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/fleet_header.jpg" class="fleet-header-img" alt="Filo Header">
</div>

<style>
.fleet-header-wrapper {
    width: 654px;
    height: 200px;
    margin: 0 auto 15px auto;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,0.5);
}

.fleet-header-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
</style>

<table class="table table-sm fs-12 table-gow">
	<thead>
		<tr>
			<th colspan="9" class="border border-secondary">
				<div class="transparent" style="text-align:left;float:left;">{$LNG.fl_fleets}: ({$activeFleetSlots} / {$maxFleetSlots})</div>
				<div class="transparent" style="text-align:right;float:right;">{$LNG.fl_expeditions}: ({$activeExpedition} / {$maxExpedition}) </div>
			</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td>{$LNG.fl_number}</td>
			<td>{$LNG.fl_mission}</td>
			<td>{$LNG.fl_ammount}</td>
			<td>{$LNG.fl_beginning}</td>
			<td>{$LNG.fl_departure}</td>
			<td>{$LNG.fl_destiny}</td>
			<td>{$LNG.fl_arrival}</td>
			<td>{$LNG.fl_objective}</td>
			<td>{$LNG.fl_order}</td>
		</tr>
		{foreach name=FlyingFleets item=FlyingFleetRow from=$FlyingFleetList}
		<tr>
			<td style="vertical-align:middle;">{$smarty.foreach.FlyingFleets.iteration}</td>
			<td style="vertical-align:middle;">
				<a data-bs-toggle="tooltip"
				   data-bs-placement="top"
				   data-bs-html="true" title="
				   <table class='fs-12'>
						<thead></thead>
						<tbody>
							<tr>
								<td style='width:50%;color:white'>{$LNG['tech'][901]}</td>
								<td style='width:50%;color:white'>{$FlyingFleetRow.metal}</td>
							</tr>
							<tr>
								<td style='width:50%;color:white'>{$LNG['tech'][902]}</td><td style='width:50%;color:white'>{$FlyingFleetRow.crystal}</td>
							</tr>
							<tr>
								<td style='width:50%;color:white'>{$LNG['tech'][903]}</td><td style='width:50%;color:white'>{$FlyingFleetRow.deuterium}</td>
							</tr>
							<tr>
								<td style='width:50%;color:white'>{$LNG['tech'][921]}</td><td style='width:50%;color:white'>{$FlyingFleetRow.dm}</td>
							</tr>
						</tbody>
				   </table>">
					{$LNG["type_mission_{$FlyingFleetRow.mission}"]}
				</a>
				{if $FlyingFleetRow.state == 1}
					<br><a title="{$LNG.fl_returning}">{$LNG.fl_r}</a>
				{else}
					<br><a title="{$LNG.fl_onway}">{$LNG.fl_a}</a>
				{/if}
			</td>
			<td style="vertical-align:middle;">
				<a data-bs-toggle="tooltip"
				   data-bs-placement="top"
				   data-bs-html="true"
				   title="<table><tr><th colspan='2' style='text-align:center;'>{$LNG.fl_info_detail}</th></tr>{foreach $FlyingFleetRow.FleetList as $shipID => $shipCount}<tr><td class='transparent'>{$LNG.tech.{$shipID}}:</td><td class='transparent'>{$shipCount}</td></tr>{/foreach}</table>">
					{$FlyingFleetRow.amount}
				</a>
			</td>
			<td style="vertical-align:middle;">
				<a href="game.php?page=galaxy&amp;galaxy={$FlyingFleetRow.startGalaxy}&amp;system={$FlyingFleetRow.startSystem}">[{$FlyingFleetRow.startGalaxy}:{$FlyingFleetRow.startSystem}:{$FlyingFleetRow.startPlanet}]</a>
			</td>
			<td style="vertical-align:middle;" {if $FlyingFleetRow.state == 0}style="color:lime"{/if}>{$FlyingFleetRow.startTime}</td>
			<td style="vertical-align:middle;">
				<a href="game.php?page=galaxy&amp;galaxy={$FlyingFleetRow.endGalaxy}&amp;system={$FlyingFleetRow.endSystem}">[{$FlyingFleetRow.endGalaxy}:{$FlyingFleetRow.endSystem}:{$FlyingFleetRow.endPlanet}]</a>
			</td>
			{if $FlyingFleetRow.mission == 4 && $FlyingFleetRow.state == 0}
				<td style="vertical-align:middle;">-</td>
			{else}
				<td style="vertical-align:middle;" {if $FlyingFleetRow.state != 0}style="color:lime"{/if}>{$FlyingFleetRow.endTime}</td>
			{/if}
			<td style="vertical-align:middle;" id="fleettime_{$smarty.foreach.FlyingFleets.iteration}" class="fleets" data-fleet-end-time="{$FlyingFleetRow.returntime}" data-fleet-time="{$FlyingFleetRow.resttime}">{pretty_fly_time({$FlyingFleetRow.resttime})}</td>
			<td style="vertical-align:middle;">
				{if !$isVacation && $FlyingFleetRow.state != 1 && $FlyingFleetRow.no_returnable != 1}
					<form action="game.php?page=fleetTable&amp;action=sendfleetback" method="post">
						<input name="fleetID" value="{$FlyingFleetRow.id}" type="hidden">
						<input class="btn bg-black px-1 py-1 fs-12 text-white" value="{$LNG.fl_send_back}" type="submit">
					</form>
					{if $FlyingFleetRow.mission == 1}
						<form action="game.php?page=fleetTable&amp;action=acs" method="post">
							<input name="fleetID" value="{$FlyingFleetRow.id}" type="hidden">
							<input value="{$LNG.fl_acs}" type="submit">
						</form>
					{/if}
				{else}
					&nbsp;-&nbsp;
				{/if}
			</td>
		</tr>
		{foreachelse}
		<tr>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
			<td>-</td>
		</tr>
		{/foreach}
		{if $maxFleetSlots == $activeFleetSlots}
			<tr><td colspan="9">{$LNG.fl_no_more_slots}</td></tr>
		{/if}
	</tbody>
</table>
{* =======================================================
   NOVAPUS — OGAME TARZI FİLO HAREKETİ YENİ MODERN GÖRÜNÜM
   ======================================================= *}
<link rel="stylesheet" href="styles/theme/gow/fleetmodern.css">

<div class="nova-fleet-modern-wrapper">

    {if $FlyingFleetList|@count == 0}
        <div class="nova-fleet-empty-modern">
            Şu anda uçan filon yok.
        </div>
    {else}

        {foreach $FlyingFleetList as $F}

        <div class="nova-fleet-modern-card"
             data-start="{$F.startTimestamp}"
             data-end="{$F.endTimestamp}"
             data-rest="{$F.resttime}">

            <div class="nova-fleet-modern-header">
                <span class="mission mission-{$F.mission}">
                    {$LNG["type_mission_{$F.mission}"]}
                </span>
                <span class="countdown"></span>
            </div>

            <div class="nova-fleet-modern-path">

                <div class="planet start">
                    <div class="icon planet-blue"></div>
                    <div class="coords">[{$F.startGalaxy}:{$F.startSystem}:{$F.startPlanet}]</div>
                </div>

                <div class="path-line" id="bar-{$F.id}">
    <div class="grid"></div>
    <div class="line"></div>

    <!-- HAREKET EDECEK GEMİ -->
    <img id="ship-{$F.id}" class="fleet-ship-icon"
         src="styles/theme/gow/images/ship.png">
</div>


                <div class="planet end">
                    <div class="icon planet-green"></div>
                    <div class="coords">[{$F.endGalaxy}:{$F.endSystem}:{$F.endPlanet}]</div>
                </div>

            </div>

            <div class="nova-fleet-modern-footer">

                <div class="times">
                    <span>Kalkış: {$F.startTime}</span>
                    <span class="arrow">➜</span>
                    <span>Varış: {$F.endTime}</span>
                </div>

                <div class="actions">
                    {if !$isVacation && $F.state == 0 && !$F.no_returnable}
                        <a href="game.php?page=fleetTable&action=sendfleetback&fleetID={$F.id}" class="btn-return">
                            Geri Dönüş
                        </a>
                    {/if}
                </div>

            </div>

        </div>

        {/foreach}

    {/if}

</div>


{if  isModuleAvailable($smarty.const.MODULE_AUTOEXPEDITION) && empty($targetMission)}
<form action="?page=AutoExpedition" method="post">
	<table class="table table-sm fs-12 table-gow my-2">
		<thead>
		<th class="text-center border border-secondary" colspan="3">{$LNG.ae_autoexp}</th>
		</thead>
		<tbody>
		<tr>
			<td class="text-center">{$LNG.ae_galaxy}</td>
			<td class="text-center">{$LNG.ae_system}</td>
			<td class="text-center">{$LNG.ae_planet}</td>
		</tr>
		<tr>
			<td>
				<input class="form-control bg-dark text-white text-center p-0 my-0 mx-auto w-50 fs-12" name="expedition_galaxy" value="{$galaxy}">
			</td>
			<td>
				<input class="form-control bg-dark text-white text-center p-0 my-0 mx-auto w-50 fs-12" name="expedition_system" value="{$system}">
			</td>
			<td>
				<input class="form-control bg-dark text-white text-center p-0 my-0 mx-auto w-50 fs-12" name="expedition_planet" value="16">
			</td>
		</tr>
		<tr>
			<td class="text-center" colspan="2">
				<span>{$LNG.fl_hold_time}</span>
				<select class="" name="">
					{foreach $StaySelector as $cKey => $cSelector}
						<option value="{$cKey}">{$cSelector}</option>
					{/foreach}
				</select>
				<span>{$LNG.fl_hours}</span>
			</td>
			<td class="text-center" colspan="1">
				<span onclick="return Dialog.fleetDivideSettings();" class="settingsoverview">{$LNG.ae_settings}</span>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<div class="g-recaptcha mx-auto d-flex justify-content-center" data-theme="dark" data-sitekey="{$recaptchaPublicKey}"></div>
			</td>
		</tr>
		<tr>
			<td class="text-center" colspan="3">
				<button class="btn btn-dark py-0 px-1 border border-secondary fs-12 text-yellow" type="submit">{$LNG.ae_send}</button>
			</td>
		</tr>
		</tbody>
	</table>
</form>
{/if}

{if !empty($acsData)}
	{include file="shared.fleetTable.acsTable.tpl"}
{/if}

{* ============================================================
   OGAME STİLİ GEMİ SEÇİM EKRANI (FLEET 1)
   ============================================================ *}

<form action="?page=fleetStep1" method="post">
	<input type="hidden" name="galaxy" value="{$targetGalaxy}">
	<input type="hidden" name="system" value="{$targetSystem}">
	<input type="hidden" name="planet" value="{$targetPlanet}">
	<input type="hidden" name="type" value="{$targetType}">
	<input type="hidden" name="target_mission" value="{$targetMission}">

	<div class="nova-fleet-wrapper">

		{* --- Savaş Gemileri --- *}
		<h3 class="nova-fleet-section-title">{$LNG.fl_combat_ships|default:'Savaş Gemileri'}</h3>
		<div class="nova-fleet-grid">
			{foreach $FleetsOnPlanet as $FleetRow}
				{if $FleetRow.speed != 0 && $FleetRow.id >= 204 && $FleetRow.id <= 215}
					<div class="nova-ship-card">
						<div class="nova-ship-image">
							<img src="{$dpath}gebaeude/{$FleetRow.id}.gif" alt="{$LNG.tech.{$FleetRow.id}}">
						</div>

						<div class="nova-ship-name">
							{$LNG.tech.{$FleetRow.id}}
						</div>

						<div class="nova-ship-available">
							{$LNG.fl_ship_available}: <span id="ship{$FleetRow.id}_value">{$FleetRow.count}</span>
						</div>

						<div class="nova-ship-input">
							<button type="button" class="nova-ship-btn" onclick="minShip('ship{$FleetRow.id}');">-</button>
							<input class="nova-ship-field"
								   name="ship{$FleetRow.id}"
								   id="ship{$FleetRow.id}_input"
								   size="10"
								   value="0">
							<button type="button" class="nova-ship-btn" onclick="maxShip('ship{$FleetRow.id}');">+</button>
						</div>

						<div class="nova-ship-speed">
							{if $FleetRow.speed != 0}
								<span>{$LNG.fl_speed_title}: {$FleetRow.speed}</span>
							{/if}
						</div>
					</div>
				{/if}
			{/foreach}
		</div>

		{* --- Sivil Gemiler --- *}
		<h3 class="nova-fleet-section-title mt-3">{$LNG.fl_civil_ships|default:'Sivil Gemiler'}</h3>
		<div class="nova-fleet-grid">
			{foreach $FleetsOnPlanet as $FleetRow}
				{if $FleetRow.speed != 0 && !($FleetRow.id >= 204 && $FleetRow.id <= 215)}
					<div class="nova-ship-card">
						<div class="nova-ship-image">
							<img src="{$dpath}gebaeude/{$FleetRow.id}.gif" alt="{$LNG.tech.{$FleetRow.id}}">
						</div>

						<div class="nova-ship-name">
							{$LNG.tech.{$FleetRow.id}}
						</div>

						<div class="nova-ship-available">
							{$LNG.fl_ship_available}: <span id="ship{$FleetRow.id}_value">{$FleetRow.count}</span>
						</div>

						<div class="nova-ship-input">
							<button type="button" class="nova-ship-btn" onclick="minShip('ship{$FleetRow.id}');">-</button>
							<input class="nova-ship-field"
								   name="ship{$FleetRow.id}"
								   id="ship{$FleetRow.id}_input"
								   size="10"
								   value="0">
							<button type="button" class="nova-ship-btn" onclick="maxShip('ship{$FleetRow.id}');">+</button>
						</div>

						<div class="nova-ship-speed">
							{if $FleetRow.speed != 0}
								<span>{$LNG.fl_speed_title}: {$FleetRow.speed}</span>
							{/if}
						</div>
					</div>
				{/if}
			{/foreach}
		</div>

		{* Alt kontrol butonları *}
		<div class="nova-fleet-actions">
			{if count($FleetsOnPlanet) == 0}
				<div class="text-center text-muted">{$LNG.fl_no_ships}</div>
			{else}
				<div class="nova-fleet-actions-left">
					<button type="button" class="btn btn-dark py-0 px-2 border border-secondary fs-12 text-yellow" onclick="noShips();">
						{$LNG.fl_remove_all_ships}
					</button>
					<button type="button" class="btn btn-dark py-0 px-2 border border-secondary fs-12 text-yellow" onclick="maxShips();">
						{$LNG.fl_select_all_ships}
					</button>
				</div>
				{if $maxFleetSlots != $activeFleetSlots}
					<div class="nova-fleet-actions-right">
						<input class="button-upgrade nova-fleet-continue" type="submit" value="{$LNG.fl_continue}">
					</div>
				{/if}
			{/if}
		</div>

	</div>
</form>

<br>
<table class="table table-sm bg-black fs-12 table-gow">
	<thead>
	<tr>
		<th class="text-center border border-secondary" colspan="3">{$LNG.fl_bonus}</th>
	</tr>
	<tr>
		<th style="width:33%;" class="text-center border border-secondary">{$LNG.fl_bonus_attack}</th>
		<th style="width:33%;" class="text-center border border-secondary">{$LNG.fl_bonus_defensive}</th>
		<th style="width:33%;" class="text-center border border-secondary">{$LNG.fl_bonus_shield}</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td class="text-center  border border-secondary">+{$bonusAttack} %</td>
		<td class="text-center border border-secondary">+{$bonusDefensive} %</td>
		<td class="text-center border border-secondary">+{$bonusShield} %</td>
	</tr>
	<tr>
		<th class="text-center border border-secondary">{$LNG.tech.115}</th>
		<th class="text-center border border-secondary">{$LNG.tech.117}</th>
		<th class="text-center border border-secondary">{$LNG.tech.118}</th>
	</tr>
	<tr>
		<td class="text-center">+{$bonusCombustion} %</td>
		<td class="text-center">+{$bonusImpulse} %</td>
		<td class="text-center">+{$bonusHyperspace} %</td>
	</tr>
	</tbody>
</table>

{block name="script" append}
	<script src="scripts/game/fleetTable.js"></script>
	<script type="text/javascript" src="https://www.google.com/recaptcha/api.js?hl={$lang}"></script>
	<script src="scripts/game/fleetModern.js"></script>

{/block}

{/block}
