{block name="title" prepend}{$LNG.lm_technology}{/block}

{block name="content"}
<!-- HEADER -->
<div class="techtree-header-wrapper">
    <img src="styles/theme/gow/img/headers/tech_header.jpg" class="techtree-header-img" alt="">
</div>

<style>
.techtree-header-wrapper{
    width:654px;
    height:200px;
    margin:0 auto 20px auto;
    border-radius:6px;
    overflow:hidden;
    box-shadow:0 0 14px rgba(0,0,0,0.45);
}

.techtree-header-img{
    width:100%;
    height:100%;
    object-fit:cover;
}
</style>

<style>
.techWrapper { width:100%; }

.techtree-category{
    width: 90%;
    margin: 10px auto;
    padding: 8px 12px;
    background: rgba(0,0,0,.35);
    border: 1px solid rgba(255,255,255,.08);
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
}

.tech-grid-center{
    width:100%;
    display:flex;
    justify-content:center;
}

.tech-item{
    background: rgba(0,0,0,.45);
    border:1px solid rgba(255,255,255,.06);
    border-radius:8px;
    width:260px;
    padding:15px;
    margin:15px auto;
    text-align:center;
}

.tech-img{
    width:92px;
    height:92px;
    object-fit:cover;
    margin-bottom:6px;
}

.tech-name{ color:white;font-weight:600;margin-bottom:5px; }
.tech-req-title{ color:#9cc;font-size:12px;margin-bottom:4px; }

.req-ok{ color:#6f6;font-size:12px; }
.req-need{ color:#ffb400;font-size:12px; }
</style>

<script>
function toggleTechDiv(id){
    let box = $('.h' + id);
    let icon = $('#button_icon_' + id);

    if(box.hasClass('d-none')){
        box.removeClass('d-none');
        icon.removeClass('bi-plus-circle').addClass('bi-dash-circle');
    } else {
        box.addClass('d-none');
        icon.removeClass('bi-dash-circle').addClass('bi-plus-circle');
    }
}
</script>

<div class="techWrapper">

{foreach $TechTreeList as $elementID => $requireList}

    {if !is_array($requireList)}

        <div class="techtree-category" onclick="toggleTechDiv({$elementID});">
            <button class="btn btn-dark p-0" style="width:20px;height:20px;">
                <i id="button_icon_{$elementID}" class="bi bi-plus-circle"></i>
            </button>
            <span class="fs-12 text-white">{$LNG.tech.$requireList}</span>
        </div>

    {else}

        {if $requireList}

        <div class="tech-grid-center d-none
            {if ($elementID < 100)}h0
            {elseif ($elementID < 200)}h100
            {elseif ($elementID < 300)}h200
            {elseif ($elementID < 500)}h400
            {elseif ($elementID < 600)}h500
            {elseif ($elementID < 700)}h600
            {/if}
        ">

            <!-- TEKNOLOJİ TEK KART -->
            <div class="tech-item">

                <a href="#" onclick="return Dialog.info({$elementID});">
                    <img class="tech-img"
                         src="{$dpath}gebaeude/{$elementID}.{if $elementID >=600 && $elementID <=699}jpg{else}gif{/if}">
                </a>

                <div class="tech-name">
                    {$LNG.tech.$elementID}
                </div>

                <div class="tech-req-title">{$LNG.tt_requirements}:</div>

                <!-- GEREKSİNİMLER TEK TEK -->
                {foreach $requireList as $reqID => $Need}
                    <div class="{if $Need.own < $Need.count}req-need{else}req-ok{/if}">
                        {$LNG.tech.$reqID} ({$LNG.tt_lvl} {$Need.own}/{$Need.count})
                    </div>
                {/foreach}

            </div>

        </div>

        {/if}

    {/if}

{/foreach}

</div>

{/block}